% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DownsetOf.R
\name{DownsetOf}
\alias{DownsetOf}
\title{Computing downsets.}
\usage{
DownsetOf(poset, elements)
}
\arguments{
\item{poset}{An object of S4 class \code{POSet}.
Argument \code{poset} must be created by using any function contained in the package aimed at building object of S4 class \code{POSet}
(e.g. \code{\link[=POSet]{POSet()}}, \code{\link[=LinearPOSet]{LinearPOSet()}}, \code{\link[=ProductPOSet]{ProductPOSet()}}, ...) .}

\item{elements}{A vector of character strings (the names of the input elements).}
}
\value{
A vector of character strings (the names of the elements of the downset).
}
\description{
Computes the downset of a set of elements of the input poset.
}
\examples{
elems<- c("a", "b", "c", "d")

dom <- matrix(c(
  "a", "b",
  "c", "b",
  "a", "d"
), ncol = 2, byrow = TRUE)

pos <- POSet(elements = elems, dom = dom)

dwn <- DownsetOf(pos, c("b","d"))

}
