% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multi_xy_to_df.R
\name{multi_xy_to_df.multiXY}
\alias{multi_xy_to_df.multiXY}
\title{Convert a multiXY object to a data frame.}
\usage{
\method{multi_xy_to_df}{multiXY}(x, tth, ...)
}
\arguments{
\item{x}{a \code{multiXY} object.}

\item{tth}{a logical value denoting whether the 2theta scale is appended as the
first column. Default \code{= TRUE}.}

\item{...}{other arguments}
}
\value{
A \code{data.frame}.
}
\description{
\code{multi_xy_to_df.multiXY} converts multiXY objects to a column-wise data frame.
}
\examples{
#Load the minerals library
data(soils)

soils_df1 <- multi_xy_to_df(soils, tth = TRUE)
soils_df2 <- multi_xy_to_df(soils, tth = FALSE)
}
