% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PlotQQPlot.R
\name{plot_qq_plot}
\alias{plot_qq_plot}
\title{Create Q-Q plot}
\usage{
plot_qq_plot(
  x,
  transformer,
  show_original = TRUE,
  show_identity = TRUE,
  use_alpha = TRUE,
  ggtheme = NULL
)
}
\arguments{
\item{x}{A vector with numeric values that should be transformed to
normality.}

\item{transformer}{A transformer object created using
\code{find_transformation_parameters}.}

\item{show_original}{Show quantiles for original, untransformed, data in
addition to transformed data.}

\item{show_identity}{Show identity line that indicates equivalence between
expected and observed quantiles.}

\item{use_alpha}{Use transparency for points in case the data contains many
instances.}

\item{ggtheme}{\code{ggplot2} theme to use for the plot. If not provided,
\code{ggplot2::theme_light} is used.}
}
\value{
A \code{ggplot2} plot object for a Q-Q plot.
}
\description{
Create a figure that plots the expected, theoretical normal quantiles
(z-scores) against the observed normal quantiles (z-scores) of the data.
}
\examples{
x <- exp(stats::rnorm(1000))
transformer <- find_transformation_parameters(
  x = x,
  method = "box_cox")

if (rlang::is_installed("ggplot2")) {
  plot_qq_plot(
    x = x,
    transformer = transformer
  )
}

}
