% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/x_from_power.R
\name{x_from_power}
\alias{x_from_power}
\alias{n_from_power}
\alias{n_region_from_power}
\alias{print.x_from_power}
\alias{print.n_region_from_power}
\title{Sample Size and Effect Size Determination}
\usage{
x_from_power(
  object,
  x,
  pop_es_name = NULL,
  target_power = 0.8,
  what = c("point", "ub", "lb"),
  goal = switch(what, point = "ci_hit", ub = "close_enough", lb = "close_enough"),
  ci_level = 0.95,
  tolerance = 0.02,
  x_interval = switch(x, n = c(50, 2000), es = NULL),
  extendInt = NULL,
  progress = TRUE,
  simulation_progress = TRUE,
  max_trials = 10,
  final_nrep = 400,
  final_R = 1000,
  seed = NULL,
  x_include_interval = FALSE,
  check_es_interval = TRUE,
  power_curve_args = list(power_model = NULL, start = NULL, lower_bound = NULL,
    upper_bound = NULL, nls_control = list(), nls_args = list()),
  save_sim_all = FALSE,
  algorithm = NULL,
  control = list()
)

n_from_power(
  object,
  pop_es_name = NULL,
  target_power = 0.8,
  what = c("point", "ub", "lb"),
  goal = switch(what, point = "ci_hit", ub = "close_enough", lb = "close_enough"),
  ci_level = 0.95,
  tolerance = 0.02,
  x_interval = c(50, 2000),
  extendInt = NULL,
  progress = TRUE,
  simulation_progress = TRUE,
  max_trials = 10,
  final_nrep = 400,
  final_R = 1000,
  seed = NULL,
  x_include_interval = FALSE,
  check_es_interval = TRUE,
  power_curve_args = list(power_model = NULL, start = NULL, lower_bound = NULL,
    upper_bound = NULL, nls_control = list(), nls_args = list()),
  save_sim_all = FALSE,
  algorithm = NULL,
  control = list()
)

n_region_from_power(
  object,
  pop_es_name = NULL,
  target_power = 0.8,
  ci_level = 0.95,
  tolerance = 0.02,
  x_interval = c(50, 2000),
  extendInt = NULL,
  progress = TRUE,
  simulation_progress = TRUE,
  max_trials = 10,
  final_nrep = 400,
  final_R = 1000,
  seed = NULL,
  x_include_interval = FALSE,
  check_es_interval = TRUE,
  power_curve_args = list(power_model = NULL, start = NULL, lower_bound = NULL,
    upper_bound = NULL, nls_control = list(), nls_args = list()),
  save_sim_all = FALSE,
  algorithm = NULL,
  control = list()
)

\method{print}{x_from_power}(x, digits = 3, ...)

\method{print}{n_region_from_power}(x, digits = 3, ...)
}
\arguments{
\item{object}{A \code{power4test} object,
which is the output of \code{\link[=power4test]{power4test()}}.
Can also be a \code{power4test_by_n} object,
the output
of \code{\link[=power4test_by_n]{power4test_by_n()}}, or
a \code{power4test_by_es} object, the
output of
\code{\link[=power4test_by_es]{power4test_by_es()}}. For these
two types of objects, the attempt
with power closest to the
\code{target_power} will be used as
\code{object}, and all other attempts in
them will be included in the estimation
of subsequent attempts and the final
output. Last, it can also be the
output of a previous call to
\code{\link[=x_from_power]{x_from_power()}}, and the stored
trials will be retrieved.}

\item{x}{For \code{\link[=x_from_power]{x_from_power()}},
\code{x} set the value to
be searched. Can be \code{"n"}, the sample
size, or \code{"es"}, the population value
of a parameter (set by \code{pop_es_name}).
For the \code{print} method of \code{x_from_power}
objects, this is the output of
\code{\link[=x_from_power]{x_from_power()}}.}

\item{pop_es_name}{The name of the
parameter. Required if \code{x} is \code{"es"}.
See the help page
of \code{\link[=ptable_pop]{ptable_pop()}} on the names for
the argument \code{pop_es}.}

\item{target_power}{The target power,
a value greater than 0 and less than
one.}

\item{what}{The value for which is
searched: the estimate power (\code{"point"}),
the upper bound of the confidence
interval (\code{"ub"}), or the lower bound
of the confidence interval (\code{"lb"}).}

\item{goal}{The goal of the search.
If \code{"ci_hit"}, then the goal is to
find a value of \code{x} with the
confidence interval of the estimated
power including the target power.
If \code{"close_enough"}, then the goal
is to find a value of \code{x} with the
value in \code{what} "close enough" to
the target power, defined by having
an absolute difference with the
target power less than \code{tolerance}.}

\item{ci_level}{The level of confidence
of the confidence intervals computed
for the estimated power. Default is
.95, denoting 95\%.}

\item{tolerance}{Used when the goal
is \code{"close_enough"}.}

\item{x_interval}{A vector of
two values, the minimum value
and the maximum values of \code{x}, in
the search for the values
(sample sizes or population values).
If \code{NULL}, default when \code{x = "es"},
it will be determined internally.}

\item{extendInt}{Whether \code{x_interval}
can be expanded when estimating the
the values to try. The value will
be passed to the argument of the
same name in \code{\link[stats:uniroot]{stats::uniroot()}}.
If \code{x} is \code{"n"}, then the default
value is \code{"upX"}.
That is, a value higher than
the maximum in \code{x_interval} is
allowed, if predicted by the tentative
model. Otherwise, the default value
is \code{"no"}. See the help page of
\code{\link[stats:uniroot]{stats::uniroot()}} for further
information.}

\item{progress}{Logical. Whether
the searching progress is reported.}

\item{simulation_progress}{Logical.
Whether the progress in each call
to \code{\link[=power4test]{power4test()}}, \code{\link[=power4test_by_n]{power4test_by_n()}},
or \code{\link[=power4test_by_es]{power4test_by_es()}}
is shown. To be passed to
the \code{progress} argument of these
functions.}

\item{max_trials}{The maximum number
of trials in searching the value
with the target power. Rounded
up if not an integer.}

\item{final_nrep}{The number of
replications in the final stage,
also the maximum number of replications
in each call to \code{\link[=power4test]{power4test()}},
\code{\link[=power4test_by_n]{power4test_by_n()}}, or
\code{\link[=power4test_by_es]{power4test_by_es()}}.}

\item{final_R}{The number of
Monte Carlo simulation or
bootstrapping samples in the final
stage. The \code{R} in calling
\code{\link[=power4test]{power4test()}}, \code{\link[=power4test_by_n]{power4test_by_n()}},
or \code{\link[=power4test_by_es]{power4test_by_es()}}
will be stepped up to this value
when approaching the target
power. Do not need to be very large
because the goal is to estimate
power by replications, not for high
precision in one single replication.}

\item{seed}{If not \code{NULL}, \code{\link[=set.seed]{set.seed()}}
will be used to make the process
reproducible. This is not always
possible if many stages of
parallel processing is involved.}

\item{x_include_interval}{Logical.
Whether the minimum and maximum
values in \code{x_interval} are mandatory
to be included in the values
to be searched.}

\item{check_es_interval}{If \code{TRUE},
the default, and \code{x} is \code{"es"},
a conservative probable
range of valid values for the selected
parameter will be determined, and it
will be used instead of \code{x_interval}.
If the range spans both positive and
negative values, only the interval
of the same sign as the population
value in \code{object} will be used.}

\item{power_curve_args}{A named
list of arguments to be passed
\code{\link[=power_curve]{power_curve()}} when estimating
the relation between power and \code{x}
(sample size or effect size). Please
refer to \code{\link[=power_curve]{power_curve()}} on available
arguments. There is one except:
\code{power_model} is mapped to
the \code{formula} argument of
\code{\link[=power_curve]{power_curve()}}.}

\item{save_sim_all}{If \code{FALSE},
the default, the data in each
\code{power4test} object for each
value of \code{x} is not saved,
to reduce the size of the output.
If set to \code{TRUE}, the size of the
output can be very large in size.}

\item{algorithm}{The algorithm for
finding \code{x}. Can be \code{"power_curve"}
or \code{"bisection"}. The default algorithm
depends on \code{x}.}

\item{control}{A named list of
additional
arguments to be passed to the
algorithm to be used. For advanced
users.}

\item{digits}{The number of digits
after the decimal when printing
the results.}

\item{...}{Optional arguments.
Not used for now.}
}
\value{
The function \code{\link[=x_from_power]{x_from_power()}}
returns an \code{x_from_power} object,
which is a list with the following
elements:
\itemize{
\item \code{power4test_trials}: The output of
\code{\link[=power4test_by_n]{power4test_by_n()}} for all sample
sizes examined, or of
\code{\link[=power4test_by_es]{power4test_by_es()}} for all
population values of the selected
parameter examined.
\item \code{rejection_rates}: The output of
\code{\link[=rejection_rates]{rejection_rates()}}.
\item \code{x_tried}: The sample sizes or
population values
examined.
\item \code{power_tried}: The estimated
rejection rates for all the values
examined.
\item \code{x_final}: The sample size or
population value in the
solution. \code{NA} if a solution not found.
\item \code{power_final}: The estimated power
of the value in the solution.
\code{NA} if a solution not found.
\item \code{i_final}: The position of the
solution in \code{power4test_trials}.
\code{NA} if a solution not found.
\item \code{ci_final}: The confidence interval
of the estimated power in the solution,
formed by normal approximation.
\code{NA} if a solution not found.
\item \code{ci_level}: The level of confidence
of \code{ci_final}.
\item \code{nrep_final}: The number of
replications (\code{nrep}) when estimating
the power in the solution.
\item \code{power_curve}: The output of
\code{\link[=power_curve]{power_curve()}} when estimating the
power curve.
\item \code{target_power}: The requested
target power.
\item \code{power_tolerance}: The allowed
difference between the solution's
estimated power and the target
power. Determined by the number
of replications and the level of
confidence of the confidence intervals.
\item \code{x_estimated}: The value
(sample size or population value)
with the target power, estimated by
\code{power_curve}. This is used, when
solution not found, to determine the
range of the values to search when
calling the function again.
\item \code{start}: The time and date when
the process started.
\item \code{end}: The time and date when the
process ended.
\item \code{time_spent}: The time spent in
doing the search.
\item \code{args}: A named list of the arguments
of \code{\link[=x_from_power]{x_from_power()}} used in the search.
\item \code{call}: The call when this function
is called.
}

The function \code{\link[=n_region_from_power]{n_region_from_power()}}
returns a named list of two output of
\code{\link[=n_from_power]{n_from_power()}}, of the class
\code{n_region_from_power}. The output
with \code{what = "ub"} is named \code{"below"},
and the output with \code{what = "lb"} is
namd \code{"above"}.

The \code{print}-method of \code{x_from_power}
objects returns the object \code{x}
invisibly.
It is called for its side effect.

The \code{print}-method of \code{x_from_power_region}
objects returns the object \code{x}
invisibly.
It is called for its side effect.
}
\description{
It searches by simulation
the sample size (given other factors,
such as effect sizes) or effect size
(given other factors, such as sample
size) with power to
detect an effect close to a target
value.
}
\details{
This is how to use \code{\link[=x_from_power]{x_from_power()}}:
\itemize{
\item Specify the model by \code{\link[=power4test]{power4test()}},
with \code{do_the_test = FALSE}, and set
the magnitude of the effect sizes
to the minimum levels to detect.
\item Add the test using \code{\link[=power4test]{power4test()}}
using \code{test_fun} and \code{test_args}
(see the help page of \code{\link[=power4test]{power4test()}}
for details). Run it on the
starting sample size or
effect size.
\item Call \code{\link[=x_from_power]{x_from_power()}} on the output
of \code{\link[=power4test]{power4test()}} returned from
the previous step. This
function will iteratively repeat
the analysis on either other sample
sizes, or other values for a
selected model parameter (the
effect sizes),
trying to achieve a goal (\code{goal}) for
a value of interest (\code{what}).
}

If the \code{goal} is \code{"ci_hit"}, the
search will try to find a value (a sample
size, or a population value of
the selected model parameter) with
a power level close enough to the
target power, defined by having its
confidence interval for the power
including the target power.

If the \code{goal} is \code{"close_enough"},
then the search will try to find a
value of \code{x} with its level of
power (\code{"point"}), the upper bound
of the confidence interval for this
level of power (\code{"ub"}), or the
lower bound of the confidence interval
fro this level of power (\code{"lb"})
"close enough" to the target level of
power, defined by having an absolute
difference less than the \code{tolerance}.

If several values of \code{x} (sample
size or the population value of
a model parameter) have already been
examined by \code{\link[=power4test_by_n]{power4test_by_n()}} or
\code{\link[=power4test_by_es]{power4test_by_es()}}, the output
of these two functions can also be
used as \code{object} by \code{\link[=x_from_power]{x_from_power()}}.

Usually, the default values of the
arguments should be sufficient.

The results can be viewed using
\code{\link[=summary]{summary()}}, and the output has
a \code{plot} method (\code{\link[=plot.x_from_power]{plot.x_from_power()}}) to
plot the relation between power and
values (of \code{x}) examined.

A detailed illustration on how to
use this function for sample size can be found
from this page:

\url{https://sfcheung.github.io/power4mome/articles/x_from_power_for_n.html}

The function \code{\link[=n_from_power]{n_from_power()}} is just
a wrapper of \code{\link[=x_from_power]{x_from_power()}}, with
\code{x} set to \code{"n"}.

The function \code{\link[=n_region_from_power]{n_region_from_power()}} is just
a wrapper of \code{\link[=x_from_power]{x_from_power()}}, with
\code{x} set to \code{"n"}, with two passes, one
with \code{what = "ub"} and one with
\code{what = "lb"}.

The \code{print} method only prints
basic information. Call the
\code{summary} method of \code{x_from_power} objects
(\code{\link[=summary.x_from_power]{summary.x_from_power()}}) and its
\code{print} method for detailed results
}
\section{Algorithms}{
Two algorithms are currently available,
the simple (though inefficient)
bisection method, and a method that
makes use of the estimated crude power
curve.

Unlike typical root-finding problems,
the prediction of the level of power
is stochastic. Moreover, the computational
cost is high when Monte Carlo or
bootstrap confidence intervals are
used to do a test because the estimation
of the power for one single value of
\code{x} can sometimes take one minute or
longer. Therefore, in addition to
the simple bisection method, a method,
named \emph{power curve} method, was also
specifically developed for this
scenario.
\subsection{Bisection Method}{

This method, \code{algorithm = "bisection"},
basically starts with
an interval that probably encloses the
value of \code{x} that meets the goal,
and then successively narrows this
interval. The mid-point of this
interval is used as the estimate.
Though simple, there are cases in
which it can be slow. Nevertheless,
preliminary examination suggests that
this method is good enough for common
scenarios. Therefore, this method is
the default algorithm when \code{x} is
\code{n}.
}

\subsection{Power Curve Method}{

This method, \code{algorithm = "power_curve"},
starts with a crude
power curve based on a few points.
This tentative model is then used
to suggest the values to examine in
the next iteration. The form, not
just the parameters, of the
model can change across iterations,
as more and more data points are
available.

This method can be used only with
the goal \code{"ci_hit"}.
This method is the default method
for \code{x = "es"} with \code{goal = "ci_hit"}
because the relation
between the power and the population
value of a parameter varies across
parameters, unlike the relation
between power and sample size. Therefore,
taking into account the working
power curve may help finding the
desired value of \code{x}.

The technical internal workflow of
this method implemented in
\code{\link[=x_from_power]{x_from_power()}} can be found in
this page: \url{https://sfcheung.github.io/power4mome/articles/x_from_power_workflow.html}.
}
}

\examples{

# Specify the population model

mod <-
"
m ~ x
y ~ m + x
"

# Specify the population values

mod_es <-
"
m ~ x: m
y ~ m: l
y ~ x: n
"

# Generate the datasets

sim_only <- power4test(nrep = 5,
                       model = mod,
                       pop_es = mod_es,
                       n = 100,
                       do_the_test = FALSE,
                       iseed = 2345)

# Do a test

test_out <- power4test(object = sim_only,
                       test_fun = test_parameters,
                       test_args = list(pars = "m~x"))

# Determine the sample size with a power of .80 (default)

# In real analysis, to have more stable results:
# - Use a larger final_nrep (e.g., 400).

# If the default values are OK, this call is sufficient:
# power_vs_n <- x_from_power(test_out,
#                            x = "n",
#                            seed = 4567)
power_vs_n <- x_from_power(test_out,
                           x = "n",
                           progress = TRUE,
                           target_power = .80,
                           final_nrep = 5,
                           max_trials = 1,
                           seed = 1234)
summary(power_vs_n)
plot(power_vs_n)


}
\seealso{
\code{\link[=power4test]{power4test()}}, \code{\link[=power4test_by_n]{power4test_by_n()}},
and \code{\link[=power4test_by_es]{power4test_by_es()}}.
}
