% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/missing_data.R
\name{dropout_manual}
\alias{dropout_manual}
\title{Manually specify dropout per time point}
\usage{
dropout_manual(...)
}
\arguments{
\item{...}{The proportion of dropout per time point, either as
a vector of length \code{n1}, or \code{n1} individual numeric arguments,
see \emph{Details}.}
}
\value{
A list of class \code{plcp_dropout_manual}
}
\description{
Used as input to the \code{dropout}-argument in \code{\link{study_parameters}}.
}
\details{
Specifying dropout manually requires that the dropout
is 0 at the first time point. Moreover, dropout can't decrease over time and
can never be 1.
}
\examples{
dropout <- dropout_manual(0, 0, 0, 0, 0.2, 0.2, 0.3, 0.3, 0.4, 0.4, 0.45)

p <- study_parameters(n1 = 11,
                      n2 = 5,
                      n3 = 6,
                      T_end = 10,
                      icc_pre_subject = 0.5,
                      icc_pre_cluster = 0,
                      var_ratio = 0.03,
                      icc_slope = 0.05,
                      dropout = dropout,
                      cohend = -0.8)
plot(p, plot = 2)
get_power(p)

# Can also use a vector as input
dropout <- dropout_manual(seq(0, 0.5, length.out = 11))
p <- study_parameters(n1 = 11,
                      n2 = 5,
                      n3 = 6,
                      T_end = 10,
                      icc_pre_subject = 0.5,
                      icc_pre_cluster = 0,
                      var_ratio = 0.03,
                      icc_slope = 0.05,
                      dropout = dropout,
                      cohend = -0.8)
plot(p, plot = 2)
get_power(p)

\dontrun{
# Decreasing dropout will throw an error
dropout_manual(0, 0.1, 0.1, 0.2, 0.1)

# Dropout at the first time point will throw an error
dropout_manual(0.1, 0.1, 0.1, 0.2, 0.2)
}
}
\seealso{
\code{\link{dropout_weibull}}, \code{\link{per_treatment}}
}
