% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/crt.xo.cont.R
\name{crt.xo.cont}
\alias{crt.xo.cont}
\title{Power for test of treatment effect in 2x2 crossover cluster randomized trial}
\usage{
crt.xo.cont(
  m = NULL,
  J.arm = NULL,
  delta = NULL,
  sd = 1,
  icc = 0,
  icca = 0,
  iccb = NULL,
  cac = NULL,
  sac = 0,
  alpha = 0.05,
  power = NULL,
  sides = 2,
  v = FALSE
)
}
\arguments{
\item{m}{The number of subjects measured during each cluster-period.}

\item{J.arm}{The number of clusters in each arm.}

\item{delta}{The difference between the intervention and control means under the alternative minus the difference under the null hypothesis.}

\item{sd}{The total standard deviation of the outcome variable; defaults to 1.}

\item{icc}{The within-cluster, within-period intraclass correlation coefficient; defaults to 0.}

\item{icca}{The  within-cluster, within-subject correlation (correlation between two measurements within the same subject); defaults to 0.}

\item{iccb}{The within-cluster, between-period intraclass correlation coefficient. Either iccb OR cac must be specified.}

\item{cac}{The cluster autocorrelation. Either iccb OR cac must be specified.}

\item{sac}{The subject autocorrelation; defaults to 0.}

\item{alpha}{The significance level or type 1 error rate; defaults to 0.05.}

\item{power}{The specified level of power.}

\item{sides}{Either 1 or 2 (default) to specify a one- or two- sided hypothesis test.}

\item{v}{Either TRUE for verbose output or FALSE to output computed argument only.}
}
\value{
A list of the arguments (including the computed one).
}
\description{
Power and sample size calculation for a 2x2 crossover cluster randomized trial.
Can solve for power, number of clusters per arm (assumes equal number of
cluster per arm), m, delta or alpha.
}
\examples{
crt.xo.cont(m = 30, J.arm = 4, delta = 0.3, icc = 0.05, cac = 0.8, sac = 0.4)
crt.xo.cont(m = 30, J.arm = 4, delta = 0.3, icc = 0.05, icca = 0.42, iccb = 0.04)
crt.xo.cont(m = 30, J.arm = 4, delta = 0.3, icc = 0.05, cac = 0.5)
}
