% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as.annual.r
\name{as.annual}
\alias{as.annual}
\alias{as.precintcon.annual}
\title{Converting to seasonal precipitation serie.}
\usage{
as.annual(object)
}
\arguments{
\item{object}{a precintcon.daily, precintcon.monthly, 
or precintcon.seasonal object or a data.frame containing 33 or 3 columns.}
}
\value{
A data.frame (precintcon.annual) containing the following variables:
\itemize{
\item \code{year} is the year.
\item \code{precipitation} is the precipitation amount in millimeters.
}
}
\description{
Converts a daily, monthly, or seasonal precipitation serie to an 
annual serie.
}
\examples{
##
# Loading the daily precipitation serie.
data(daily)

##
# Converting precipitation
as.annual(daily)
}
\author{
Lucas Venezian Povoa \email{lucasvenez@gmail.com}
}
\seealso{
\code{\link{as.daily}}
\code{\link{as.monthly}}
\code{\link{as.seasonal}}
\code{\link{pplot.lorenz}}
\code{\link{read.data}}
}
\keyword{annual}
\keyword{precipitation}

