% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/03BaseClass.R
\name{setpreprocessor}
\alias{setpreprocessor}
\title{setpreprocessor}
\usage{
setpreprocessor(classname, operation, mode = "numeric")
}
\arguments{
\item{classname}{(character)}

\item{operation}{(expression as character string)}

\item{mode}{(character) default to "numeric" for operation to be computed on data frame with numeric variables, option="all" for DataClass object with S4 slots x (numeric variables) and y (factor of class labels)}
}
\value{
NULL definition of S4 class derived from PreprocessorClass and corresponding transformdata-method
}
\description{
setpreprocessor is a constructor function for defining a preprocessor. The main
argument is the operation that is executed to transform the data such as "na.omit(basedata)"
for removing rows that have missing values. An operation can process either only the numeric
columns or also the class label column.
}
\details{
If an operation deletes rows from numeric columns, the corresponding class
labels are deleted automatically. If an operation uses both numeric columns
and class labels, the defined operation must return both.
}
\examples{
## Set of examples using only numeric variables and no class labels
## setpreprocessor("naomit", "na.omit(basedata)")
## setpreprocessor("scale", "scale(basedata,center=FALSE)")
## setpreprocessor("nooutlierremove", "identity(basedata)")
## setpreprocessor("softmaxscale", "data.frame(apply(basedata, 2, DMwR::SoftMax))")
##
## An example using also class labels and a supporting function
## setpreprocessor("randomforestimpute", "rfimputefunc(basedata)", mode="all")
}

