% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prereg_specify.R
\name{prereg_specify}
\alias{prereg_specify}
\title{Specify the content for one or more (pre)registration items}
\usage{
prereg_specify(
  x,
  ...,
  append = TRUE,
  validate = TRUE,
  requireValidContent = TRUE,
  silent = preregr::opts$get("silent")
)
}
\arguments{
\item{x}{The (pre)registration object (as produced by a call to
\code{\link[=prereg_initialize]{prereg_initialize()}}).}

\item{...}{Item-content pairings.}

\item{append}{Whether to replace (\code{append=FALSE}) or append (\code{append=TRUE})
the content if an item already contains some content.}

\item{validate}{Whether to validate the specified content for each item
using the validation rules in the (pre)registration form.}

\item{requireValidContent}{Whether to only store new content if it passes
validation. Note that this is ignored if \code{validate=FALSE}.}

\item{silent}{Whether to be silent or chatty.}
}
\value{
x, invisibly
}
\description{
Specify the content for one or more (pre)registration items
}
\examples{
### Load an example (pre)registration specification
data("examplePrereg_1", package = "preregr");

### Specify some fields and show the results
examplePrereg_1 |>
  preregr::prereg_specify(
    tasks_and_roles = "All authors contributed equally",
    nonExistent_item = "This can't be stored anywhere",
    start_date = "2021-9-01"
  ) |>
  preregr::prereg_show_item_completion(
    section="metadata"
  );
}
