% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/correlation_measures.R
\name{prec_cronb}
\alias{prec_cronb}
\title{Sample size or precision for Cronbach's alpha}
\usage{
prec_cronb(k, calpha, n = NULL, conf.level = 0.95, conf.width = NULL)
}
\arguments{
\item{k}{number of measurements/items.}

\item{calpha}{desired Cronbach's alpha.}

\item{n}{sample size.}

\item{conf.level}{confidence level.}

\item{conf.width}{precision (the full width of the confidence interval).}
}
\value{
Object of class "presize", a list of arguments (including the
  computed one) augmented with method and note elements.
}
\description{
\code{prec_cronb} returns the sample size or the precision for the given
Cronbach's alpha.
}
\details{
Exactly one of the parameters \code{n} or \code{conf.width} must be passed as NULL,
and that parameter is determined from the other.

Sample size or precision is calculated according to the formula & code and
provided in Bonett and Wright (2014).

n is rounded up to the next whole number using \code{ceiling}.
}
\examples{
# calculate confidence interval width...
prec_cronb (k=5,calpha=0.7,n= 349,conf.level= 0.95, conf.width= NULL)
# calculate N required for a given confidence interval width...
prec_cronb (k=5,calpha=0.7,n= NULL,conf.level= 0.95, conf.width= 0.1)
}
\references{
Bonett, D. G. and Wright, T. A. (2015) \emph{Cronbach's alpha reliability: Interval estimation, hypothesis testing, and sample size planning} J. Organiz. Behav., 36, pages 3– 15. \doi{10.1002/job.1960}.
 # k= number of items
}
