% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pressuRe_functions.R
\name{animate_pressure}
\alias{animate_pressure}
\title{Animate pressure}
\usage{
animate_pressure(
  pressure_data,
  plot_colors = "default",
  fps,
  dpi = 96,
  file_name
)
}
\arguments{
\item{pressure_data}{Array. A 3D array covering each timepoint of the
measurement. z dimension represents time}

\item{plot_colors}{String}

\item{fps}{Numeric. Number of frames per second in animation}

\item{dpi}{Numeric. Resolution of gif}

\item{file_name}{Name (inlcuding path) of export file}
}
\value{
Animation in gif format
}
\description{
Produces animation (gif) of pressure data
}
\examples{
\dontshow{if (interactive()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
emed_data <- system.file("extdata", "emed_test.lst", package = "pressuRe")
pressure_data <- load_emed(emed_data)
animate_pressure(pressure_data, fps = 10, file_name = "testgif.gif")
\dontshow{\}) # examplesIf}
}
