% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pressuRe_functions.R
\name{mask_analysis}
\alias{mask_analysis}
\title{Analyze masked regions of pressure data}
\usage{
mask_analysis(
  pressure_data,
  partial_sensors = FALSE,
  variable = "press_peak_sensor",
  pressure_units = "kPa",
  area_units = "cm2"
)
}
\arguments{
\item{pressure_data}{List. Includes a 3D array covering each timepoint of the
measurement. z dimension represents time}

\item{partial_sensors}{Logical Defines how sensors that do not
lie wholly within mask are dealt with. If FALSE, they will be excluded;
if TRUE, for relevant variables their contribution will be weighted by the
proportion of the sensor that falls within the mask border}

\item{variable}{String. Variable to be determined. "press_peak_sensor",
"press_peak_mask", "contact_area_peak", "pti_1", "pti_2",
"force_time_integral", "force_peak"}

\item{pressure_units}{String. Default "kPa". Other options: "MPa", "Ncm2"
(Newtons per square centimeter)}

\item{area_units}{String. Default is "cm2" (square centimeters). Other
options "m2" (square meters); "mm2" (square millimeters)}
}
\value{
Data frame. Contains values for each mask plus additional information
relevant to the data including cycle/step and foot side
}
\description{
Analyze masked regions of pressure data
}
\examples{
emed_data <- system.file("extdata", "emed_test.lst", package = "pressuRe")
pressure_data <- load_emed(emed_data)
pressure_data <- create_mask_auto(pressure_data, "automask_simple", plot = FALSE)
mask_analysis(pressure_data, FALSE, variable = "press_peak_sensor")
}
