% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulationsfunctions.R
\name{generate_I_fast}
\alias{generate_I_fast}
\title{Function to simulate PPS and data and calculate a number of estimators}
\usage{
generate_I_fast(n.sample, P, dist.X.loi, data.theo = NULL,
  dist.X.los = NA, one.factor.loi = 1, one.factor.los = 1)
}
\arguments{
\item{n.sample}{number of beds to simulate}

\item{P}{average prevalence of nosocomial infections}

\item{dist.X.loi}{vector of probabilities for values 1:length(dist.X.loi) of X.loi}

\item{data.theo}{data frame with theoretical info generated by simulate_incidence_stats_* function}

\item{dist.X.los}{vector of probabilities for values 1:length(dist.X.los) of X.los}

\item{one.factor.loi}{factor by which to approx. reduce number of one day observations for A.loi}

\item{one.factor.los}{factor by which to approx. reduce number of one day observations for A.los}
}
\value{
data frame with following columns \itemize{
   \item{n - number of patients sampled} 
   \item{n.noso - number of HAIs}
   \item{P.hat - estimate of prevalence P}
   \item{I.hat - estimate of incidence rate I}
   \item{I.pp.hat - estimate of incidence proportion per admission I.pp}
   \item{x.loi.hat - estimate of x.loi}
   \item{x.los.hat - estimate of x.los}
   \item{method - name of the method}
}
and rows for the estimators gren, rear, pps.median, pps.mean, pps.mixed, 
rhame.theo, L.full 
(for a description of the estimators see vignette).
}
\description{
Function to simulate PPS and data and calculate a number of estimators
}
\examples{
example.dist <- create_dist_vec(function(x) dpois(x-1, 7), max.dist = 70)
generate_I_fast(200, P = 0.05, example.dist )

}
