% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_cplex_solver.R
\name{add_cplex_solver}
\alias{add_cplex_solver}
\title{Add a \emph{CPLEX} solver}
\usage{
add_cplex_solver(
  x,
  gap = 0.1,
  time_limit = .Machine$integer.max,
  presolve = TRUE,
  threads = 1,
  verbose = TRUE
)
}
\arguments{
\item{x}{\code{\link[=problem]{problem()}} (i.e. \code{\linkS4class{ConservationProblem}}) object.}

\item{gap}{\code{numeric} gap to optimality. This gap is relative when
solving problems using \emph{Gurobi} or \emph{CPLEX}, and will cause the optimizer to
terminate when the difference between the upper and lower objective
function bounds is less than the gap times the upper bound. For example, a
value of 0.01 will result in the optimizer stopping when the difference
between the bounds is 1 percent of the upper bound.}

\item{time_limit}{\code{numeric} time limit in seconds to run the optimizer.
The solver will return the current best solution when this time limit is
exceeded.}

\item{presolve}{\code{logical} should the presolver be used to simplify the
problem before solving it? The default value is \code{TRUE}.}

\item{threads}{\code{integer} number of threads to use for the
optimization algorithm. The default value of 1 will result in only
one thread being used.}

\item{verbose}{\code{logical} should information be printed while solving
optimization problems?}
}
\value{
Object (i.e. \code{\linkS4class{ConservationProblem}}) with the solver
added to it.
}
\description{
Specify that the \emph{IBM CPLEX} software should be used to solve a
conservation planning problem. This function can also be used to
customize the behavior of the solver. It requires the \pkg{cplexAPI} package.
}
\details{
\href{https://www.ibm.com/analytics/cplex-optimizer}{\emph{IBM CPLEX}} is a
commercial optimization software. Although this software is faster than
the available open source solvers (i.e \code{\link[=add_lpsymphony_solver]{add_lpsymphony_solver()}} and
\code{\link[=add_rsymphony_solver]{add_rsymphony_solver()}}, it is slower than the \emph{Gurobi} solver
(\code{\link[=add_gurobi_solver]{add_gurobi_solver()}}).
Licenses are available for the \emph{IBM CPLEX} software to academics at no cost
(see \url{https://www.ibm.com/products/ilog-cplex-optimization-studio}).

The pkg{cplexAPI} package is used to interface with \emph{IBM CPLEX}. To install
this package, the \code{CPLEX_BIN} variable must be set (similar to
the \code{GUROBI_HOME} variable for the \emph{Gurobi} software) to specify
the file path for the \emph{CPLEX} software. For example, on a Linux system,
this variable can be specified by adding
\verb{export CPLEX_BIN="/opt/ibm/ILOG/CPLEX_Studio128/cplex/bin/x86-64_linux/cplex"}
to the \verb{~/.bashrc} file. Note that you may need to change the version
number in the file parth (i.e. \code{"CPLEX_Studio128"}). For more information
on installing the pkg{cplexAPI} package, please see the
\href{https://CRAN.R-project.org/package=cplexAPI/INSTALL}{official installation instructions for the package}.
}
\examples{
# load data
data(sim_pu_raster, sim_features)

# create problem
p <- problem(sim_pu_raster, sim_features) \%>\%
  add_min_set_objective() \%>\%
  add_relative_targets(0.1) \%>\%
  add_binary_decisions()
\dontrun{
# if the package is installed then add solver and generate solution
if (require("cplexAPI")) {
  # specify solver and generate solution
  s <- p \%>\% add_cplex_solver(gap = 0.1, time_limit = 5) \%>\%
             solve()

  # plot solutions
  plot(stack(sim_pu_raster, s), main = c("planning units", "solution"),
       axes = FALSE, box = FALSE)
}
}
}
\seealso{
\link{solvers}.
}
