% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/english_names.R
\name{make_english_names}
\alias{make_english_names}
\title{Generates a random name from a list of common English words.}
\usage{
make_english_names(n, n_words = 3, retry = FALSE)
}
\arguments{
\item{n}{The number of random names to be generated.}

\item{n_words}{The number of words to combine into a name.}

\item{retry}{If `TRUE`, a random integer between 1 and 10 is appended to each
generated name.}
}
\value{
A random name formatted as "word_word" (for example,
"every_complete_company").
}
\description{
This function generates `n` random names, each a combination of `n_words`
words selected from [common_words].
}
\examples{
make_english_names(1, n_words = 2)
make_english_names(2, retry = TRUE)
}
