% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modmedEquation.R
\name{modmedEquation}
\alias{modmedEquation}
\title{Make moderated mediation equation}
\usage{
modmedEquation(X = "", M = NULL, Y = "", moderator = list(),
  labels = NULL, range = FALSE, covar = list())
}
\arguments{
\item{X}{A character vectors indicating independent variables}

\item{M}{A character vectors indicating mediators}

\item{Y}{A character vectors indicating dependent variables}

\item{moderator}{moderator}

\item{labels}{labels}

\item{range}{Whether or not add range equation}

\item{covar}{Optional list of covariates}
}
\description{
Make moderated mediation equation
}
\examples{
X="X";Y="Y"
moderator=list(name=c("Z"),site=list(c("a","c")))
cat(modmedEquation(X=X,Y=Y,moderator=moderator,range=TRUE))
X="X";M="M";Y="Y"
cat(modmedEquation(X=X,M=M,Y=Y,range=TRUE))
X="X";M="M";Y="Y"
moderator=list(name=c("Z"),site=list(c("a","c")))
cat(modmedEquation(X=X,M=M,Y=Y,moderator=moderator,range=TRUE))
X="X";M="M";Y="Y";labels=NULL;range=FALSE
moderator=list(name=c("X"),site=list(c("b")))
cat(modmedEquation(X=X,M=M,Y=Y,moderator=moderator,range=FALSE))
X="X";Y="Y"
moderator=list(name=c("Z"),site=list(c("c")))
cat(modmedEquation(X=X,Y=Y,moderator=moderator,range=FALSE))
covar=list(name=c("C1","C2","C3"),label=c("ese","sex","tenure"),site=list(c("M","Y"),"Y","Y"))
cat(modmedEquation(X=X,M="M",Y=Y,moderator=moderator,range=FALSE,covar=covar))
}
