% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/drawCatModel.R
\name{drawCatModel}
\alias{drawCatModel}
\title{Draw statistical diagram including categorical X}
\usage{
drawCatModel(
  xcount = 3,
  M = NULL,
  W = NULL,
  whatLabel = "name",
  addDots = TRUE,
  xmargin = 0.01,
  radx = 0.08,
  ymargin = 0.02,
  xlim = c(-0.2, 1.2),
  ylim = xlim,
  rady = 0.04,
  maxypos = 0.6,
  minypos = 0.2,
  ypos = c(1, 0.5),
  mpos = c(0.5, 0.9),
  xinterval = NULL,
  yinterval = NULL,
  box.col = "white",
  xspace = NULL,
  label.pos = list()
)
}
\arguments{
\item{xcount}{integer length of categorical variables}

\item{M}{character name of mediator variable}

\item{W}{character name of moderator variable}

\item{whatLabel}{What should the edge labels indicate in the path diagram? Choices are c("est","name")}

\item{addDots}{logical.}

\item{xmargin}{horizontal margin between nodes}

\item{radx}{horizontal radius of the box.}

\item{ymargin}{vertical margin between nodes}

\item{xlim}{the x limits (min,max) of the plot}

\item{ylim}{the y limits (min,max) of the plot}

\item{rady}{vertical radius of the box.}

\item{maxypos}{maximal y position of X or W variables}

\item{minypos}{minimal y position of X or W variables}

\item{ypos}{The x and y position of Y node. Default value is c(1,0.5)}

\item{mpos}{The x and y position of M node. Default value is c(0.5,0.9)}

\item{xinterval}{numeric. Horizontal intervals among labels for nodes and nodes}

\item{yinterval}{numeric. Vertical intervals among labels for nodes and nodes}

\item{box.col}{fill color of the box}

\item{xspace}{numeric. Horizontal distance between nodes}

\item{label.pos}{Optional list of arrow label position}
}
\description{
Draw statistical diagram including categorical X
}
\examples{
drawCatModel(xcount=4)
drawCatModel(M="M",box.col="yellow")
drawCatModel(W="W",xlim=c(-0.08,1),ylim=c(0.13,0.95),ypos=c(1,0.55))
drawCatModel(M="M",W="W",xlim=c(-0.08,1),ylim=c(0.13,0.95),ypos=c(1,0.55))
drawCatModel(xcount=4,M="M",W="W",xlim=c(-0.08,1),ylim=c(0.13,0.95),ypos=c(1,0.55))
}
