% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/custom.R
\name{custom}
\alias{custom}
\title{Custom map profile}
\usage{
custom(
  FUN = mean,
  attribute,
  units = "",
  color_scale = "PuBu",
  color_edges = "dodgerblue4"
)
}
\arguments{
\item{FUN}{A summary function to be called on the provided event attribute, e.g. mean, median, min, max. na.rm = T by default.}

\item{attribute}{The name of the case attribute to visualize (should be numeric)}

\item{units}{Character to be placed after values (e.g. EUR for monitary euro values)}

\item{color_scale}{Name of color scale to be used for nodes. Defaults to PuBu. See `Rcolorbrewer::brewer.pal.info()` for all options.}

\item{color_edges}{The color used for edges. Defaults to dodgerblue4.}
}
\description{
Function to create a custom map profile based on some event log attribute.
}
\details{
If used for edges, it will show the attribute values which related to the out-going node of the edge.#'
}
\examples{
\dontrun{
library(eventdataR)
library(processmapR)
data(traffic_fines)
# make sure the amount attribute is propagated forward in each trace
# using zoo::na.locf instead of tidyr::fill since it is much faster
# still the whole pre-processing is still very slow
library(zoo)

traffic_fines_prepared <- traffic_fines \%>\%
filter_trace_frequency(percentage = 0.8) \%>\%
group_by_case() \%>\%
mutate(amount = na.locf(amount, na.rm = F)) \%>\%
ungroup_eventlog()

process_map(traffic_fines_prepared, type_nodes = custom(attribute = "amount", units = "EUR"))
}

}
