% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/process_matrix.R
\name{process_matrix}
\alias{process_matrix}
\alias{process_matrix.eventlog}
\alias{process_matrix.activitylog}
\title{Create process matrix}
\usage{
process_matrix(log, type, ..., eventlog = deprecated())

\method{process_matrix}{eventlog}(log, type = frequency(), ..., eventlog = deprecated())

\method{process_matrix}{activitylog}(log, type = frequency(), ..., eventlog = deprecated())
}
\arguments{
\item{log}{\code{\link[bupaR:log]{log}}: Object of class \code{\link[bupaR:log]{log}} or derivatives (\code{\link[bupaR:grouped_log]{grouped_log}},
\code{\link[bupaR:eventlog]{eventlog}}, \code{\link[bupaR:activitylog]{activitylog}}, etc.).}

\item{type}{A process matrix type, which can be created with the functions frequency, performance and custom. The first type focusses on the frequency aspect of a process, while the second one focussed on processing time. The third one allows custom attributes to be used.}

\item{...}{Other arguments}

\item{eventlog}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}}; please use \code{log} instead.}
}
\description{
Create process matrix
}
\section{Methods (by class)}{
\itemize{
\item \code{process_matrix(eventlog)}: Process matrix for event log

\item \code{process_matrix(activitylog)}: Process matrix for activity log

}}
