% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotBivariateProfiles.R
\name{plotBivariateProfiles}
\alias{plotBivariateProfiles}
\title{Plot bivariate profiles}
\usage{
plotBivariateProfiles(bivProf, allPsi, Design = NULL, threshold = NULL,
  whichIQR = NULL, plot_options = NULL, ...)
}
\arguments{
\item{bivProf}{list returned by \code{obliqueProfiles}.}

\item{allPsi}{a list containing the matrices Psi (dim \eqn{2xd}) for which to compute the profile extrema}

\item{Design}{a matrix of dimension \eqn{(2d)x numPsi} encoding the first (\code{Design[1:d,]}) and the second ((\code{Design[(d+1):(2*d),]})) axis values.}

\item{threshold}{if not \code{NULL} plots the level as a contour.}

\item{whichIQR}{which quantiles to use for the inter-quantile range plot. If \code{NULL}, automatically selects the first and the last element of \code{bivProfres_UQ$prof_quantiles_approx}}

\item{plot_options}{list as returned by \code{setPlotOptions}.}

\item{...}{additional parameters to be passed to the plot function}
}
\value{
plots the 2d maps of the profile sup and inf of the function for each Psi in allPsi. If threshold is not NULL also contours the threshold level.
}
\description{
Plot bivariate profiles, for dimension up to 6.
}
\author{
Dario Azzimonti
}
