% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modelPlots.R
\name{performance_plot}
\alias{performance_plot}
\title{Model performance plot}
\usage{
performance_plot(
  model_list,
  type = "box",
  text_size = 10,
  palette = "viridis",
  save = FALSE,
  file_path = NULL,
  file_name = "Performance_plot",
  file_type = "pdf",
  plot_width = 7,
  plot_height = 7,
  dpi = 80
)
}
\arguments{
\item{model_list}{A \code{model_list} object from performing
\code{train_models}.}

\item{type}{Type of plot to generate. Choices are "box" or "dot."
Default is \code{"box."} for boxplots.}

\item{text_size}{Text size for plot labels, axis labels etc. Default is
\code{10}.}

\item{palette}{Viridis color palette option for plots. Default is
\code{"viridis"}. See
\code{\link[viridis:viridis]{viridis}}
for available options.}

\item{save}{Logical. If \code{TRUE} saves a copy of the plot in the
directory provided in \code{file_path}.}

\item{file_path}{A string containing the directory path to save the file.}

\item{file_name}{File name to save the plot.
Default is \code{"Performance_plot."}}

\item{file_type}{File type to save the plot.
Default is \code{"pdf"}.}

\item{plot_width}{Width of the plot. Default is \code{7}.}

\item{plot_height}{Height of the plot. Default is \code{7}.}

\item{dpi}{Plot resolution. Default is \code{80}.}
}
\value{
A \code{ggplot2} object.
}
\description{
This function generates plots to visualize model performance
}
\details{
\itemize{\item \code{performance_plot} uses resampling results from
models included in the \code{model_list} to generate plots showing model
performance.
\item The default metrics used for classification based models are "Accuracy"
and "Kappa."
\item These metric types can be changed by providing additional arguments to
the \code{train_models} function. See \code{\link[caret:train]{train}} and
\code{\link[caret:trainControl]{trainControl}} for more information.}
}
\examples{
\donttest{

## Create a model_df object
covid_model_df <- pre_process(covid_fit_df, covid_norm_df)

## Split the data frame into training and test data sets
covid_split_df <- split_data(covid_model_df)

## Fit models based on the default list of machine learning (ML) algorithms
covid_model_list <- train_models(covid_split_df)

## Generate box plots to visualize performance of different ML algorithms
performance_plot(covid_model_list)

## Generate dot plots
performance_plot(covid_model_list, type = "dot")

## Change color palette
performance_plot(covid_model_list, type = "dot", palette = "inferno")
}
}
\seealso{
\itemize{
\item \code{train_models}
\item\code{\link[caret:resamples]{resamples}}
\item \code{\link[caret:train]{train}}
\item \code{\link[caret:trainControl]{trainControl}}
}
}
\author{
Chathurani Ranathunge
}
