/*
 * Decompiled with CFR 0.152.
 */
package com.qarks.util.ui.sort;

import com.qarks.util.ui.sort.ColumnTableSorter;
import java.util.Vector;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;

public class ColumnTable<E>
extends JTable {
    protected SimpleTableModel<E> model = new SimpleTableModel();
    private ColumnTableSorter sorter;

    public ColumnTable() {
        this.setModel(this.model);
        super.setShowGrid(false);
    }

    @Override
    public void addColumn(TableColumn tableColumn) {
        tableColumn.setModelIndex(this.columnModel.getColumnCount());
        this.columnModel.addColumn(tableColumn);
    }

    public void addRow(E e) {
        this.model.add(e);
    }

    public void setRowCount(int n) {
        this.model.setRowCount(n);
    }

    public void removeAllData() {
        this.model.reset();
    }

    public void resetData(int n, int n2) {
        this.model.reset(n, n2);
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        return false;
    }

    protected class SimpleTableModel<E>
    extends DefaultTableModel {
        protected SimpleTableModel() {
        }

        @Override
        public int getColumnCount() {
            return 0;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void reset() {
            Vector vector = this.dataVector;
            synchronized (vector) {
                int n = this.dataVector.size();
                for (int i = 0; i < n; ++i) {
                    this.dataVector.set(i, null);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void reset(int n, int n2) {
            Vector vector = this.dataVector;
            synchronized (vector) {
                int n3 = this.dataVector.size();
                n = Math.max(n, 0);
                n = Math.min(n, n3);
                n2 = Math.max(n2, 0);
                n2 = Math.min(n2, n3);
                for (int i = n; i < n2; ++i) {
                    this.dataVector.set(i, null);
                }
            }
        }

        public void add(E e) {
            int n = this.dataVector.size();
            this.dataVector.add(e);
            this.fireTableRowsInserted(n, n + 1);
        }

        @Override
        public Object getValueAt(int n, int n2) {
            Object e = this.dataVector.elementAt(n);
            return e;
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
            this.dataVector.set(n, object);
            for (int i = 0; i < ColumnTable.this.columnModel.getColumnCount(); ++i) {
                this.fireTableCellUpdated(n, i);
            }
        }

        @Override
        public void setRowCount(int n) {
            int n2 = this.getRowCount();
            if (n2 == n) {
                return;
            }
            this.dataVector.setSize(n);
            if (n <= n2) {
                this.fireTableRowsDeleted(n, n2 - 1);
            } else {
                this.fireTableRowsInserted(n2, n - 1);
            }
        }
    }
}

