% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/provenance.R
\name{MDS}
\alias{MDS}
\alias{MDS.compositional}
\alias{MDS.diss}
\alias{MDS.distributional}
\title{Multidimensional Scaling}
\usage{
MDS(x, ...)

\method{MDS}{compositional}(x, classical = FALSE, ...)

\method{MDS}{distributional}(x, classical = FALSE, ...)

\method{MDS}{diss}(x, classical = FALSE, ...)
}
\arguments{
\item{x}{an object of class \code{distributional}, \code{compositional} or \code{diss}}

\item{...}{optional arguments to be passed onto \code{diss} (if
\code{x} is of class \code{compositional} or \code{distributional})
or onto \code{cmdscale} or \code{isoMDS} (if \code{x} is of class
\code{dist}).}

\item{classical}{boolean flag indicating whether classical (TRUE)
or nonmetric (FALSE) MDS should be used}
}
\value{
an object of class \code{MDS}, i.e. a list containing the
following items:

\code{points}: a two column vector of the fitted configuration

\code{classical}: a boolean flag indicating whether the MDS
configuration was obtained by classical (\code{TRUE}) or nonmetric
(\code{FALSE}) MDS.

\code{diss}: the dissimilarity matrix used for the MDS analysis

\code{stress}: (only if \code{classical=TRUE}) the final stress
achieved (in percent)
}
\description{
Performs classical or nonmetric Multidimensional Scaling analysis
}
\examples{
data(Namib)
plot(MDS(Namib$Major,classical=TRUE))
}

