.makePeptideID <- function(peprot){
    tmp = peprot[,c("peptideModSequence","z")]
    tmp = apply(tmp,2,as.character)
    apply(tmp, 1, paste, collapse = '.')
}
#' given table of peptide protein assigments generate matrix
#' @param data generated by annotatePeptides
#' @param weight weight type to use options are "count", "AA" "coverage"
#' @return sparse matrix
#' @export
#' @examples
#' data(protpepmetashort)
#' library(Matrix)
#' colnames(protpepmetashort)
#' dim(protpepmetashort)
#' xx = prepareMatrix(protpepmetashort, weight= "count")
#' #xx = prepareMatrix(protpepmetashort, weight = "AA")
#' #xx = prepareMatrix(protpepmetashort, weight = "coverage")
#' image(as.matrix(xx))
#' corProt = cor(as.matrix(xx))
#' par(mfrow =c(2,1))
#' image(corProt)
#' rownames(corProt)
#'
#' # penalise peptides matching many proteins
#' xxn = t(apply(xx, 1, function(x){x/sum(x)}))
#' dim(xxn)
#' corProtn = cor(as.matrix(xxn))
#' image(corProtn)
#' rownames(corProtn)
prepareMatrix <- function(data, weight = "count" ){
    fprots = as.factor(data[,"proteinID"])
    prots = as.integer(fprots)
    fpeps = as.factor(.makePeptideID(data))
    peps = as.integer(fpeps)
    if(weight=="count"){
        pepProt =sparseMatrix(peps , prots, x = 1 )
    } else if(weight == "AA") {
        pepProt = sparseMatrix(peps, prots, x = data[,"lengthPeptide"] )
    } else if(weight == "coverage"){
        pepProt = sparseMatrix(peps, prots, x = data[,"lengthPeptide"] / data[,"lengthProtein"] )
    } else {
        stopifnot(FALSE)
    }
    colnames(pepProt) <- levels(fprots)
    rownames(pepProt) <- levels(fpeps)
    dim(pepProt)
    return(pepProt)
}

