# PRQL query

    Code
      cat(prql_compile("from a | select [b]"))
    Output
      SELECT
        b
      FROM
        a
      
      -- Generated by PRQL compiler version 0.4.1 (https://prql-lang.org)

---

    Code
      cat(prql_compile("from a | select [b]", NA, FALSE, FALSE))
    Output
      SELECT b FROM a

---

    Code
      cat(compile(
        "from star_wars\n    select [star_wars.*]\n    select ![jar_jar_binks, midichlorians]",
        "duckdb", TRUE, TRUE))
    Output
      SELECT
        * EXCLUDE (jar_jar_binks, midichlorians)
      FROM
        star_wars
      
      -- Generated by PRQL compiler version 0.4.1 (https://prql-lang.org)

# Dialects dialect=ansi

    Code
      cat(prql_compile(query, dialect, TRUE, FALSE))
    Output
      SELECT
        origin,
        dest,
        COUNT(*) AS num_flts,
        ROUND(AVG(arr_delay), 0) AS avg_delay
      FROM
        flights
      WHERE
        distance BETWEEN 200
        AND 300
        AND air_time IS NOT NULL
      GROUP BY
        origin,
        dest
      ORDER BY
        origin DESC,
        avg_delay
      LIMIT
        2

# Dialects dialect=bigquery

    Code
      cat(prql_compile(query, dialect, TRUE, FALSE))
    Output
      SELECT
        origin,
        dest,
        COUNT(*) AS num_flts,
        ROUND(AVG(arr_delay), 0) AS avg_delay
      FROM
        flights
      WHERE
        distance BETWEEN 200
        AND 300
        AND air_time IS NOT NULL
      GROUP BY
        origin,
        dest
      ORDER BY
        origin DESC,
        avg_delay
      LIMIT
        2

# Dialects dialect=clickhouse

    Code
      cat(prql_compile(query, dialect, TRUE, FALSE))
    Output
      SELECT
        origin,
        dest,
        COUNT(*) AS num_flts,
        ROUND(AVG(arr_delay), 0) AS avg_delay
      FROM
        flights
      WHERE
        distance BETWEEN 200
        AND 300
        AND air_time IS NOT NULL
      GROUP BY
        origin,
        dest
      ORDER BY
        origin DESC,
        avg_delay
      LIMIT
        2

# Dialects dialect=generic

    Code
      cat(prql_compile(query, dialect, TRUE, FALSE))
    Output
      SELECT
        origin,
        dest,
        COUNT(*) AS num_flts,
        ROUND(AVG(arr_delay), 0) AS avg_delay
      FROM
        flights
      WHERE
        distance BETWEEN 200
        AND 300
        AND air_time IS NOT NULL
      GROUP BY
        origin,
        dest
      ORDER BY
        origin DESC,
        avg_delay
      LIMIT
        2

# Dialects dialect=hive

    Code
      cat(prql_compile(query, dialect, TRUE, FALSE))
    Output
      SELECT
        origin,
        dest,
        COUNT(*) AS num_flts,
        ROUND(AVG(arr_delay), 0) AS avg_delay
      FROM
        flights
      WHERE
        distance BETWEEN 200
        AND 300
        AND air_time IS NOT NULL
      GROUP BY
        origin,
        dest
      ORDER BY
        origin DESC,
        avg_delay
      LIMIT
        2

# Dialects dialect=mssql

    Code
      cat(prql_compile(query, dialect, TRUE, FALSE))
    Output
      SELECT
        TOP (2) origin,
        dest,
        COUNT(*) AS num_flts,
        ROUND(AVG(arr_delay), 0) AS avg_delay
      FROM
        flights
      WHERE
        distance BETWEEN 200
        AND 300
        AND air_time IS NOT NULL
      GROUP BY
        origin,
        dest
      ORDER BY
        origin DESC,
        avg_delay

# Dialects dialect=mysql

    Code
      cat(prql_compile(query, dialect, TRUE, FALSE))
    Output
      SELECT
        origin,
        dest,
        COUNT(*) AS num_flts,
        ROUND(AVG(arr_delay), 0) AS avg_delay
      FROM
        flights
      WHERE
        distance BETWEEN 200
        AND 300
        AND air_time IS NOT NULL
      GROUP BY
        origin,
        dest
      ORDER BY
        origin DESC,
        avg_delay
      LIMIT
        2

# Dialects dialect=postgres

    Code
      cat(prql_compile(query, dialect, TRUE, FALSE))
    Output
      SELECT
        origin,
        dest,
        COUNT(*) AS num_flts,
        ROUND(AVG(arr_delay), 0) AS avg_delay
      FROM
        flights
      WHERE
        distance BETWEEN 200
        AND 300
        AND air_time IS NOT NULL
      GROUP BY
        origin,
        dest
      ORDER BY
        origin DESC,
        avg_delay
      LIMIT
        2

# Dialects dialect=sqlite

    Code
      cat(prql_compile(query, dialect, TRUE, FALSE))
    Output
      SELECT
        origin,
        dest,
        COUNT(*) AS num_flts,
        ROUND(AVG(arr_delay), 0) AS avg_delay
      FROM
        flights
      WHERE
        distance BETWEEN 200
        AND 300
        AND air_time IS NOT NULL
      GROUP BY
        origin,
        dest
      ORDER BY
        origin DESC,
        avg_delay
      LIMIT
        2

# Dialects dialect=snowflake

    Code
      cat(prql_compile(query, dialect, TRUE, FALSE))
    Output
      SELECT
        origin,
        dest,
        COUNT(*) AS num_flts,
        ROUND(AVG(arr_delay), 0) AS avg_delay
      FROM
        flights
      WHERE
        distance BETWEEN 200
        AND 300
        AND air_time IS NOT NULL
      GROUP BY
        origin,
        dest
      ORDER BY
        origin DESC,
        avg_delay
      LIMIT
        2

# Dialects dialect=duckdb

    Code
      cat(prql_compile(query, dialect, TRUE, FALSE))
    Output
      SELECT
        origin,
        dest,
        COUNT(*) AS num_flts,
        ROUND(AVG(arr_delay), 0) AS avg_delay
      FROM
        flights
      WHERE
        distance BETWEEN 200
        AND 300
        AND air_time IS NOT NULL
      GROUP BY
        origin,
        dest
      ORDER BY
        origin DESC,
        avg_delay
      LIMIT
        2

