% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_cov.R
\name{set_cov}
\alias{set_cov}
\title{Set up covariates}
\usage{
set_cov(n_cat, n_cont, mu_int, mu_ext, var, cov, prob_int, prob_ext)
}
\arguments{
\item{n_cat}{Number of binary variable. See details}

\item{n_cont}{Number of continuous variable}

\item{mu_int}{Mean of covariates in the internal trial. All the covariates are simulated from a
multivariate normal distribution. If left \code{NULL}, it uses default value 0 for all
covariates. If provided one value, this value is used for all covariates}

\item{mu_ext}{Mean of covariates in the external trial. If left \code{NULL}, it uses the same
mean as \code{mu_int}}

\item{var}{Variance of covariates. If left \code{NULL}, it uses default value 0 for all
covariates. If provided one value, it uses this value for all covariates}

\item{cov}{Covariance between each pair of covariates. Covariance needs to be provided in
a certain order and users are encouraged to read the example provided in the vignette. If
left \code{NULL}, it uses default value 0 for all covariates. If provided one value, it
uses this value for every pair of covariates}

\item{prob_int}{Probability of binary covariate equalling 1 in the internal trial. If left
\code{NULL}, it uses default value 0.5 for all covariates. If provided one value, it uses
this value for all covariates}

\item{prob_ext}{Probability of binary covariate equalling 1 in the external trial. If
left \code{NULL}, it uses the same probability as \code{prob_int}}
}
\value{
A \code{.covClass} class containing covariate information
}
\description{
This function saves the mean, variance and covariance among covariates. For technical
details, see the vignette.
}
\details{
Categorical variables are created by sampling a continuous variable from the multivariate
normal
distribution (thus respecting the correlation to other covariates specified by \code{cov})
and then applying a cut point derived from the \code{prob_int} or \code{prob_ext} quantile
of said distribution i.e. for a univariate variable it would be derived as:\preformatted{binvar <- as.numeric(rnorm(n, mu, sqrt(var)) < qnorm(prob, mu, sqrt(var)))
}

Please note that this means that the value of \code{mu_int} & \code{mu_ext} has no impact on categorical
covariates and thus can be set to any value.

As an example of how this process works assume \code{n_cat=3} and \code{n_cont=2}. First 5 variables are
sampled from the multivariate normal distribution as specified by \code{mu_int}/\code{mu_ext}, \code{var} &
\code{cov}. Then, the first 3 of these variables are converted to binary based on the probabilities
specified by \code{prob_int} and \code{prob_ext}. This means that that the 2 continuous variables will
take their mean and sd from the last 2 entries in the vectors \code{mu_int}/\code{mu_ext} and \code{var}.
}
\keyword{constructor}
