% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/target.sbma.R
\name{target.sbma}
\alias{target.sbma}
\title{Adaptative generation of Latin Hypercubes}
\usage{
target.sbma(target, model, factors, q = NULL, q.arg = NULL,
  res.names = NULL, method = c("HL", "random"), opts = list(),
  init = length(factors) + 2, inc = 100, FUN = min)
}
\arguments{
\item{target}{The desired SBMA.}

\item{model}{The function to be run, representing the model or simulation.
If \code{NULL}, no function is run and the object generated is incomplete, see also the \code{tell} method.}

\item{factors}{The names of the input variables (used for naming the 'data' data.frame and in plotting)
Either a vector of strings or a single number representing the number of factors}

\item{q}{The quantile functions to be used. If only one is provided, it will be used for all parameters.
Defaults to "qunif".}

\item{q.arg}{A list containing the arguments for the 'q' functions. Each parameter must be 
specified by a named list, containing all of the arguments for the quantile distribution. If unsupplied, 
default values    for the parameters are used.}

\item{res.names}{Optional: what are the names of the model results? (Used mainly for plotting)}

\item{method}{Currently, two methods are supported. "random" generates a simple LH, with no modifications. 
"HL" (the default) generates a random LH, and subsequently corrects the correlation matrix
using the Huntington & Lyrintzis method.}

\item{opts}{Further options for the method used. The method HL supports the following options:
`COR'    The desired correlation matrix between the model variables. If none is provided, the function will 
        generate a zero-correlation Latin Hypercube.
`eps'   The tolerance between the prescribed correlation and the actual correlation present in the
        generated Latin Hypercube.
`maxIt' The maximum number of iterations to be run for each factor. The default is set by a heuristic,
         but it might need some adjustments.}

\item{init}{The size of the initial LHS generated.}

\item{inc}{The increment between successive runs. For example, if init = 5 and inc = 20, the first
LHS will be generated with size 5, the second with size 25.}

\item{FUN}{When the model returns more than one response, SBMA values are calculated for each variable.
The FUN argument specifies how to combine these SBMA values. The recommended default is to
chose the minimum value.}
}
\value{
Returns the largest LHS generated.
}
\description{
Generates a series of Latin Hypercube Samples for a model until a pair of LHS
present a measure of agreement equal to or greater than a specified target.
}
