% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MI_cv_naive.R
\name{MI_cv_naive}
\alias{MI_cv_naive}
\title{Naive method for Cross-validation in Multiply Imputed datasets}
\usage{
MI_cv_naive(pobj, folds = 3, p.crit = 1, BW = FALSE, cv_naive_appt = TRUE)
}
\arguments{
\item{pobj}{An object of class \code{pmods} (pooled models), produced by a previous
call to \code{psfmi_lr}.}

\item{folds}{The number of folds, default is 3.}

\item{p.crit}{A numerical scalar. P-value selection criterium used for backward during
cross-validation. When set at 1, pooling and internal validation is done without
backward selection.}

\item{BW}{If TRUE backward selection is conducted within cross-validation. Default is FALSE.}

\item{cv_naive_appt}{Default is TRUE for showing the cross-validation apparent (train) and
test results. Set to FALSE to only give test results.}
}
\description{
\code{MI_cv_naive} Cross-validation by applying multiply imputed pooled models in train
 and test folds. Called by function \code{psfmi_perform}.
}
\seealso{
\code{\link{psfmi_perform}}
}
\author{
Martijn Heymans, 2020
}
\keyword{internal}
