% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/effective_functions.r
\name{gg_hmf}
\alias{gg_hmf}
\title{Heatmap Fit Plot using GGplot}
\usage{
gg_hmf(
  observed,
  prob,
  method = c("loess", "gam"),
  span = NULL,
  nbin = 20,
  R = 1000,
  verbose = TRUE,
  progress = TRUE,
  ...
)
}
\arguments{
\item{observed}{Vector of observe (0/1) values used in a 
binary regression model.}

\item{prob}{Vector of predicted probabilities from the model 
with \code{observed} as the dependent variable.}

\item{method}{Method for making the line - LOESS or GAM (from the \code{mgcv} package.)}

\item{span}{Optional span parameter to be passed in.  If 
\code{NULL}, AICc will be used to find the appropriate 
span for the loess smooth.}

\item{nbin}{Number of bins for the histogram.}

\item{R}{Number of boostrap resamples}

\item{verbose}{Logical indicating whether progress messages should be printed.}

\item{progress}{Logical indicating whether a progress bar should be printed during the bootstrapping.}

\item{...}{Currently unimplemented.}
}
\value{
Two ggplots - the main heatmap Fit plot and a 
histogram that can be included as a marginal density.
}
\description{
Makes a Heatmap Fit plot (Esary and Pierce, 2012) using
GGPlot rather than lattice that the \code{heatmapFit} package
uses.
}
\examples{
\donttest{
data(india)
india$bjp <- ifelse(india$in_prty == 2, 1, 0)
mod1 <- glm(bjp ~  educyrs + anti_immigration, 
            data=india, family=binomial)

gh1 <- gg_hmf(model.response(model.frame(mod1)), 
              fitted(mod1), 
              method="loess")
}
}
