Signcoef <- function (x) 
{
  if (!(class(x) == "varest")) {
    stop("\nPlease provide an object of class 'varest', generated by 'var()'.\n")
  }
  y.names <- colnames(x$datamat[, c(1:x$K)])
  Z <- x$datamat[, -c(1:x$K)]
  B <- matrix(0, nrow = x$K, ncol = ncol(Z))
  if (is.null(x$restriction)) {
    for (i in 1:x$K) {
      ps <- summary(x$varresult[[i]])$coefficients[,4]
      if (any(is.nan(ps))) ps[is.nan(ps)] <- NA
      lps <- length(ps)
      B[i, ] <- ps
    }
  }
  else if (!(is.null(x$restriction))) {
    for (i in 1:x$K) {
      restrictions <- x$restrictions
      ps <- summary(x$varresult[[i]])$coefficients[,4]
      lps <- length(ps)
      restrictions[i, restrictions[i, ] == TRUE] <- ps[!is.na(ps)]
      temp <- restrictions[i, ]
      B[i, ] <- temp
    }
  }
  colnames(B) <- colnames(Z)
  rownames(B) <- y.names
  return(B)
}