% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/anova.R
\name{aovEffectSize}
\alias{aovEffectSize}
\title{aovEffectSize}
\usage{
aovEffectSize(aovObj, effectSize = "pes")
}
\arguments{
\item{aovObj}{Output from aov or ezANOVA}

\item{effectSize}{Effect size (pes vs. ges)}
}
\value{
list
}
\description{
Add effect size to ANOVA table. Effect sizes: partial eta squared (pes),
vs. ges (generalized eta squared, NB: default when using ezANOVA).
}
\examples{
# Example 1:
# create dataframe with 2(Comp: comp vs. incomp) and 2(Side: left vs. right) factors/levels
dat <- createDF(nVP = 20, nTrl = 1,
                design = list("Comp" = c("comp", "incomp", "neutral"),
                              "Side" = c("left", "right")))

dat <- addDataDF(dat,
                 RT = list("Comp:Side_comp:left"     = c(500, 150, 150),
                           "Comp:Side_comp:right"    = c(500, 150, 150),
                           "Comp:Side_incomp:left"   = c(550, 150, 150),
                           "Comp:Side_incomp:right"  = c(550, 150, 150),
                           "Comp:Side_neutral:left"  = c(525, 150, 150),
                           "Comp:Side_neutral:right" = c(525, 150, 150)))

aovRT <- aov(RT ~ Comp * Side + Error(VP/(Comp*Side)), dat)
aovRT <- aovEffectSize(aovRT)
aovRT <- aovDispTable(aovRT)

# or with ezANOVA
library(ez)
aovRT <- ezANOVA(dat, dv=.(RT), wid = .(VP), within = .(Comp, Side),
                 return_aov = TRUE, detailed = TRUE)
aovRT <- aovEffectSize(aovRT)
aovDispTable(aovRT)

}
