% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/psychrolib.R
\name{GetTDryBulbFromEnthalpyAndHumRatio}
\alias{GetTDryBulbFromEnthalpyAndHumRatio}
\title{Return dry bulb temperature from enthalpy and humidity ratio.}
\usage{
GetTDryBulbFromEnthalpyAndHumRatio(MoistAirEnthalpy, HumRatio)
}
\arguments{
\item{MoistAirEnthalpy}{A numeric vector of moist air enthalpy in Btu lb-1 [IP] or J kg-1}

\item{HumRatio}{A numeric vector of humidity ratio in lb_H2O lb_Air-1 [IP] or kg_H2O kg_Air-1 [SI]}
}
\value{
A numeric vector of dry-bulb temperature in degreeF [IP] or degreeC [SI]
}
\description{
Return dry bulb temperature from enthalpy and humidity ratio.
}
\note{
Based on the \code{\link{GetMoistAirEnthalpy}} function, rearranged for temperature.
}
\examples{
SetUnitSystem("IP")
GetTDryBulbFromEnthalpyAndHumRatio(42.6168, seq(0.01, 0.02, 0.001))

SetUnitSystem("SI")
GetTDryBulbFromEnthalpyAndHumRatio(81316.0, seq(0.01, 0.02, 0.001))

}
\references{
ASHRAE Handbook - Fundamentals (2017) ch. 1 eqn 30
}
