% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/descriptive-utils.R
\name{describe_across}
\alias{describe_across}
\title{Apply multiple descriptive functions to multiple variables}
\usage{
describe_across(data, variables, functions, by = NULL, pivot = FALSE)
}
\arguments{
\item{data}{A data frame}

\item{variables}{A vector of variables in \code{data}}

\item{functions}{A list of summary statistic function. If it is named list, which
is recommended, the names of the functions will be used to make the names of the
returned data frame.}

\item{by}{A grouping variable. If included, the \code{data} will be grouped by the values of the
\code{by} variable before the summary statistics are applied.}

\item{pivot}{A logical variable indicating if the wide format da}
}
\value{
A tibble data frame. If \code{pivot = F}, which is the default, the data
frames contains one row per value of the \code{by} variable, or just one row overall
if there is no \code{by} variable. If \code{pivot = T}, there will be \code{k} + 1 columns
if there is no \code{by} variable, or \code{k} + 2 columns if there is a \code{by} variable,
where \code{k} is the number of functions.
}
\description{
This function is a wrapper to \code{dplyr}'s \code{summarize} used with the
\code{across} function. For each variable in a set of variables, calculate each
summary statistic from a list of summary statistic functions. Optionally,
group the variables by a grouping variable, and then calculate the
statistics. Optionally, the tibble that is returned by default, which is in a
wide format, can be pivoted to a long format.
}
\examples{
describe_across(faithfulfaces, 
                variables = c(trustworthy, faithful), 
                functions = list(avg = mean, stdev = sd),
                pivot = TRUE)
describe_across(faithfulfaces, 
                variables = c(trustworthy, faithful), 
                functions = list(avg = mean, stdev = sd), 
                by = face_sex)
describe_across(faithfulfaces, 
                variables = c(trustworthy, faithful), 
                functions = list(avg = mean, stdev = sd), 
                by = face_sex,
                pivot = TRUE)
}
