% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{alpha_hills}
\alias{alpha_hills}
\title{Estimating the Shape Parameter by Hill's Estimator}
\usage{
alpha_hills(dat, k, value = FALSE)
}
\arguments{
\item{dat}{vector of observations}

\item{k}{number of observations / value equal to or greater than to
consider for tail}

\item{value}{(TRUE/FALSE) indicating if the value which is specified
in "k" (TRUE)}
}
\value{
A list of the following form:
\describe{
  \item{shape}{Estimate of the shape parameter of the data}
  \item{scale}{Estimate of the scale parameter of the data (which is taken
  to be the minimum of the data)}
}
}
\description{
This function uses the Hill's Estimator to estimate the shape parameter
of a given set of data. (Nair et al. 2019; Pokorna 2016; Hill 1975)
It is especially useful when the data is known not to follow an exact 
Pareto distribution but the tail of the data does. Thus, the specification 
of \code{k}, the \code{k}th largest observation, allows to specify the 
point from where Pareto-like behavior may be seen. It is also possible to 
specify the value at which the tail begins.
When \code{k=n}, the Hill's Estimator returns the same estimate as 
\code{alpha_mle} with a warning notifying the user.
}
\examples{
x <- generate_pareto(10000, 5, 2)
alpha_hills(x, 400)

}
\references{
Nair J, Wierman A, Zwart B (2019). "The Fundamentals Of Heavy Tails: 
Properties, Emergence, And Identification."
http://users.cms.caltech.edu/ adamw/heavytails.html.

Pokorna M (2016). Estimation and Application of the Tail Index. 
Bachelor's thesis, Charles University in Prague, Faculty of Social 
Sciences, Institute of Economic Studies.

Hill B (1975). "A Simple General Approach To Inference About The Tail 
Of A Distribution."The Annals of Statistics, 3(5), 1163-1174.
}
