% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/style_apa.R
\name{style.apa.summary.aovlist}
\alias{style.apa.summary.aov}
\alias{style.apa.summary.aovlist}
\title{Formats the summary of a Analysis of Variance Model}
\usage{
style.apa.summary.aovlist(x, response = 1L, effect = 1L)
}
\arguments{
\item{x}{a list. First item must be the summary of a Analysis of Variance
Model from \code{\link[stats]{aov}} or \code{\link[stats]{manova}}. All other list
items will be ignored.}

\item{response}{a integer. This argument selects the desired response
variable in a \code{aovlist}. Default is appropriate for \code{aov} class.}

\item{effect}{a integer, specifying the effect that should be printed.}
}
\value{
character vector with a formatted character vector.
}
\description{
This style functions takes the summary of a Analysis of Variance Model from
\code{\link[stats]{aov}} or \code{\link[stats]{manova}} and transforms it
into a formatted character vector.
}
\details{
Please note that this is a internal style function. It is called
from \code{\link{pprint}} and not exported to user namespace. Usually
\code{\link{pprint}} determines the correct style function automatically,
but you can define the style function by using the \code{format} argument
of \code{\link{pprint}} (pass the name of this function without
\code{style.apa.} prefix). Additionally you can pass the arguments listed
in this documentation to \code{\link{pprint}}.

Argument \code{x} of this function expects a list. Be aware that you do not
have to pass a list to \code{\link{pprint}} or \code{\link{pull.pubprint}}
-- these functions will convert your arguments. This is only necessary if
you want to pass additionally information to the internal style functions
(see vignette for examples).
}
\examples{
op <- options(contrasts = c("contr.helmert", "contr.poly"))

# AOV
( npk.aov <- aov(yield ~ block + N*P*K, npk) )
summary(npk.aov)
pprint(summary(npk.aov),
       format = "summary.aov")

# MANOVA
npk2 <- within(npk, foo <- rnorm(24))
( npk2.aov <- manova(cbind(yield, foo) ~ block + N*P*K, npk2) )
summary.aov(npk2.aov)
pprint(summary.aov(npk2.aov),
       format = "summary.aovlist")

 options(op) # reset to previous
}
\seealso{
\code{\link[stats]{aov}}, \code{\link[stats]{manova}}

Other APA.style.functions: \code{\link{style.apa.anova}},
  \code{\link{style.apa.bartlett}},
  \code{\link{style.apa.character}},
  \code{\link{style.apa.chisq}},
  \code{\link{style.apa.cor.test}},
  \code{\link{style.apa.df}},
  \code{\link{style.apa.fisher}},
  \code{\link{style.apa.ks}},
  \code{\link{style.apa.numeric}},
  \code{\link{style.apa.p.value}},
  \code{\link{style.apa.shapiro}},
  \code{\link{style.apa.summary.lm.beta.coeff}},
  \code{\link{style.apa.summary.lm.coeff}},
  \code{\link{style.apa.summary.lm.equation}},
  \code{\link{style.apa.summary.lm.model}},
  \code{\link{style.apa.t.test}}
}

