% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/is_tmh.R
\name{is_tmh}
\alias{is_tmh}
\title{Determine if the protein sequence contains at least one
transmembrane helix.}
\usage{
is_tmh(protein_sequence, folder_name = get_default_pureseqtm_folder())
}
\arguments{
\item{protein_sequence}{a protein sequence}

\item{folder_name}{superfolder of PureseqTM.
The superfolder's name is \code{/home/[user_name]/.local/share}
by default, as can be obtained by
\link{get_default_pureseqtm_folder}}
}
\value{
\link{TRUE} if the protein sequence contains at least one
transmembrane helix
}
\description{
Determine if the protein sequence contains at least one
transmembrane helix.
}
\examples{
if (is_pureseqtm_installed()) {
  # This sequence is a TMH
  is_tmh("QEKNWSALLTAVVIILTIAGNILVIMAVSLEKKLQNATNYFLM")

  # This sequence is not a TMH
  is_tmh("VVIILTIRGNILVIMAVSLE")
}
}
\author{
Richèl J.C. Bilderbeek
}
