% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generations.R
\name{pop_t}
\alias{pop_t}
\title{Number of equivalent complete generations}
\usage{
pop_t(ped, name_to = "t")
}
\arguments{
\item{ped}{A dataframe containing the pedigree. Individual (id), maternal (dam), and paternal (sire) identities are mandatory columns.}

\item{name_to}{A string naming the new output column.}
}
\value{
The input dataframe, plus an additional column corresponding to the number of equivalent complete generations of every individual (named "t" by default).
}
\description{
Computes the number of equivalent complete generations (\emph{t}), as defined by Boichard et al (1997).
}
\examples{
data(dama)
pop_t(dama)
}
\references{
\itemize{
  \item{Boichard D, Maignel L, Verrier E. 1997. The value of using probabilities of gene origin to measure genetic variability in a population. Genet. Sel. Evol., 29: 5-23.}
}
}
\seealso{
\code{\link{pop_Ne}}
}
