% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PvarBreakTest.R
\name{PvarQuantile}
\alias{NormalisePvar}
\alias{PvarPvalue}
\alias{PvarQuantile}
\alias{getMean}
\alias{getSd}
\title{Quantiles and probabilities of p-variation}
\usage{
PvarQuantile(n, prob = c(0.9, 0.95, 0.99), DF = PvarQuantileDF)

PvarPvalue(n, stat, DF = PvarQuantileDF)

getMean(n, bMean = MeanCoef)

getSd(n, bSd = SdCoef)

NormalisePvar(x, n, bMean = MeanCoef, bSd = SdCoef)
}
\arguments{
\item{n}{a positive integer indicating the length of data vector.}

\item{prob}{cumulative probabilities of p-variation distribution.}

\item{DF}{a \code{data.frame} that links \code{prob} and \code{stat} .}

\item{stat}{a vector of p-variation statistics.}

\item{bMean}{a coefficient vector that defines a function of the mean of p-variation.}

\item{bSd}{a coefficient vector that defines a function of the standard deviation of p-variation.}

\item{x}{a numeric vector of data values.}
}
\value{
Functions \code{PvarQuantile} and \code{PvarPvalue} returns a corresponding value quantile or the probability.
Functions \code{getMean} and \code{getSd} returns a corresponding value of \code{mean} and \code{sd} statistics.
Function \code{NormalisePvar} returns normalize values.
}
\description{
The distribution of p-variation of \code{BridgeT(x)} depends on \code{n=length(x)}. 
This fact is important for getting appropriate quantiles (or p-value).
These functions helps to deal with it.
}
\details{
The distribution of p-variance is form Monte-Carlo simulation based on 140 millions iterations. 
The data frame \code{\link{PvarQuantileDF}} saves the results of Monte-Carlo simulation.

Meanwhile, \code{MeanCoef} and \code{SdCoef} defines the coefficients of functional 
form (conditional on \code{n}) of \code{mean} and \code{sd} statistics.

A functional form of \code{mean} and \code{sd} statistics are the same, namely
\deqn{
  f(n) = b_1 + b_2 n^b_2 .
}{
  f(n) = b_1 + b_2 * n^b_2 .
}

The coefficients \eqn{(b_1, b_2, b_3)} are saved in vectors \code{MeanCoef} and \code{SdCoef}.
Those vectors are estimated with \code{nls} function form Monte-Carlo simulation.
}
\note{
Arguments \code{n}, \code{stat} and \code{prob} might be vectors,
but they can't be vectors simultaneously (at least one of then must be a number).
}
\seealso{
\code{\link{PvarBreakTest}}, \code{\link{PvarQuantileDF}},  
\code{\link{NormalisePvar}},  \code{\link{getMean}}, \code{\link{getSd}}
}

