% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/indR2.R
\name{indR2}
\alias{indR2}
\title{Power for Comparing Independent R2 in Multiple Regression with Two or Three Predictors
Requires correlations between all variables as sample size. Means, sds, and alpha are option. Also computes Power(All)}
\usage{
indR2(ry1_1, ry2_1, ry3_1 = NULL, r12_1, r13_1 = NULL, r23_1 = NULL,
  n1, ry1_2, ry2_2, ry3_2 = NULL, r12_2, r13_2 = NULL, r23_2 = NULL,
  n2, alpha = 0.05, tails = 2)
}
\arguments{
\item{ry1_1}{Correlation between DV (y) and first predictor (1), first test}

\item{ry2_1}{Correlation between DV (y) and second predictor (2), first test}

\item{ry3_1}{Correlation between DV (y) and third predictor (3), first test}

\item{r12_1}{Correlation between first (1) and second predictor (2), first test}

\item{r13_1}{Correlation between first (1) and third predictor (3), first test}

\item{r23_1}{Correlation between second (2) and third predictor (3), first test}

\item{n1}{Sample size first test}

\item{ry1_2}{Correlation between DV (y) and first predictor (1), second test}

\item{ry2_2}{Correlation between DV (y) and second predictor (2), second test}

\item{ry3_2}{Correlation between DV (y) and third predictor (3), second test}

\item{r12_2}{Correlation between first (1) and second predictor (2), second test}

\item{r13_2}{Correlation between first (1) and third predictor (3), second test}

\item{r23_2}{Correlation between second (2) and third predictor (3), second test}

\item{n2}{Sample size second test}

\item{alpha}{Type I error (default is .05)}

\item{tails}{number of tails for test (default is 2)}
}
\value{
Power for Comparing R2 Coefficients in Multiple Regression
}
\description{
Power for Comparing Independent R2 in Multiple Regression with Two or Three Predictors
Requires correlations between all variables as sample size. Means, sds, and alpha are option. Also computes Power(All)
}
\examples{
indR2(ry1_1=.40, ry2_1=.40, ry3_1 =-.40, r12_1=-.15,r13_1=-.60, r23_1=.25,
ry1_2=.40, ry2_2=.10, ry3_2 =-.40, r12_2=-.15,r13_2=-.60, r23_2=.25,
n1=115,n2=115, alpha=.05)
}
