% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mqcs.mewma.r
\name{mqcs.mewma}
\alias{mqcs.mewma}
\alias{mqcs.mewma.default}
\alias{mqcs.mewma.mqcd}
\title{Function to plot mewma chart}
\usage{
mqcs.mewma(x, ...)

\method{mqcs.mewma}{default}(x, data.name = NULL, limits = NULL,
  Xmv = NULL, S = NULL, method = "sw", plot = FALSE, ...)

\method{mqcs.mewma}{mqcd}(x, limits = NULL, Xmv = NULL, S = NULL,
  lambda = 0.1, method = "sw", plot = FALSE, ...)
}
\arguments{
\item{x}{an R object (used to select the method). See details.}

\item{...}{arguments passed to or from methods.}

\item{data.name}{a string that specifies the title displayed on the plots. 
If not provided it is taken from the name of the object's data.}

\item{limits}{a two-values vector specifying the control limits.}

\item{Xmv}{is the mean vector. It is only specified for Phase II or when the parameters of the distribution are known.}

\item{S}{is the sample covariance matrix. It is only used for Phase II or when the parameters of the distribution are known.}

\item{method}{is the method employed to compute the covatiance matrix
in the individual observation case. Two methods are used "sw" 
for compute according to (Sullivan,Woodall 1996a) and "hm" 
by (Holmes,Mergen 1993)}

\item{plot}{a logical value indicating that it should be plotted.}

\item{lambda}{is the smoothing constant. Only values of 0.1, 0.2,...,0.9 are allowed.}
}
\description{
This function is used to compute statistics required by the mewma chart.
}
\examples{

##
##  Continuous data 
##
library(qcr)
data(dowel1)
str(dowel1)
data.mqcd <- mqcd(dowel1)
res.mqcs <- mqcs.mewma(data.mqcd)
summary(res.mqcs)
plot(res.mqcs, title =" MEWMA Control Chart for dowel1")
}
\author{
Edgar Santos-Fernandez
}

