% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qcs.ca.r
\name{qcs.ca}
\alias{qcs.ca}
\title{Capability Analysis}
\usage{
qcs.ca(object, limits = c(lsl = -3, usl = 3), target = NULL,
  std.dev = NULL, nsigmas = 3, confidence = 0.9973, plot = TRUE,
  main = NULL, ...)
}
\arguments{
\item{object}{qcs object of type \code{"qcs.xbar"} or \code{"qcs.one"}.}

\item{limits}{A vector specifying the lower and upper specification limits.}

\item{target}{A value specifying the target of the process. 
If is \code{NULL}, the target is set at the middle value bewteen specification limits.}

\item{std.dev}{A value specifying the within-group standard deviation.}

\item{nsigmas}{A numeric value specifying the number of sigmas to use.}

\item{confidence}{A numeric value between 0 and 1 specifying the probabilities for computing the quantiles.
This values is used only when object values is provided. The default value is 0.9973.}

\item{plot}{Logical value indicating whether graph should be plotted.}

\item{main}{Title of the plot.}

\item{...}{Arguments to be passed to or from methods.}
}
\description{
Calculates the process capability indices cp, cpk, cpL cpU, cpm, cpmk for a qcs object and normal distribution. 
Also, this function calculates confidence limits for \eqn{C_p}{C_p} using the method described by Chou et al. (1990). 
Approximate confidence limits for \eqn{C_{pl}}{C_pl}, \eqn{C_{pu}}{C_pu} and  \eqn{C_{pk}}{C_pk} are computed using the method in Bissell (1990). 
Confidence limits for \eqn{C_{pm}}{C_pm} are based on the method of Boyles (1991); this method is approximate and it assumes 
the target is midway between the specification limits.
Moreover, calculates the process capability indices cnp, cnpk, cnpm, cnpmk for a qcs object. 
A histogramm with a density curve is displayed along with the specification limits, a 
Quantile-Quantile Plot for the specified distribution and contour graph is plotted for estimate the indice cpm.
}
\examples{
library(qcr)
data(pistonrings) 
xbar <- qcs.xbar(pistonrings[1:125,],plot = TRUE)
LSL=73.99; USL=74.01
limits = c(lsl = 73.99, usl = 74.01)
qcs.ca(xbar, limits = limits)
}
\references{
Montgomery, D.C. (1991) \emph{Introduction to Statistical Quality Control}, 2nd
ed, New York, John Wiley & Sons. \cr
Tong, L.I. and Chen, J.P. (1998), \emph{Lower con???dence limits of process capability 
indices for nonnormal process distributions.} International Journal of Quality & Reliability Management, 
Vol. 15 No. 8/9, pp. 907-19.\cr
Vannman, K (1995) \emph{A Unified Approach to Capability Indices}. Statitica Sinica,5,805-820.\cr
Vannman, K. (2001). \emph{A Graphical Method to Control Process Capability}. Frontiers in Statistical Quality Control, 
No 6, Editors: H-J Lenz and P-TH Wilrich. Physica-Verlag, Heidelberg, 290-311.\cr
Hubele and Vannman (2004). \emph{The E???ect of Pooled and Un-pooled Variance Estimators on Cpm When Using Subsamples}.
Journal Quality Technology, 36, 207-222.\cr
}

