\name{key_merge}
\alias{key_merge}
\title{Merge Demographic Information with Person/Text Transcript}
\usage{
key_merge(transcript.df, key.df, common.column = NULL,
  defualt.arrange = TRUE)
}
\arguments{
  \item{transcript.df}{The text/person transcript
  dataframe}

  \item{key.df}{The demographic dataframe.}

  \item{common.column}{The column(s) shared by
  \code{transcript.df} and \code{key.df}.  If \code{NULL}
  function defaults to use any columns with the same name.}

  \item{defualt.arrange}{logical.  If \code{TRUE} will
  arrange the columns with text to the far right.}
}
\value{
Outputs a merged transcript dataframe with demographic
information.
}
\description{
Wrapper function (\code{\link[base]{merge}}) for merging
demographic information with a person/text transcript.
}
\examples{
\dontrun{
#First view transcript dataframe and demographics dataframe.
ltruncdf(list(raj, raj.demographics), 10, 50)
merged.raj <- key_merge(raj, raj.demographics)
htruncdf(merged.raj, 10, 40)
}
}
\seealso{
\code{\link[base]{merge}}
}
\keyword{demographic}
\keyword{merge,}

