% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/phrase_net.R
\name{phrase_net}
\alias{phrase_net}
\title{Phrase Nets}
\usage{
phrase_net(text.var, freq = 4, r = 0.35, edge.constant = 6,
  vertex.constant = 3, ...)
}
\arguments{
\item{text.var}{The text variable.}

\item{freq}{The minimum word frequency occurrence.}

\item{r}{The minimum correlation value}

\item{edge.constant}{A constant to multiple the edges by.}

\item{vertex.constant}{A constant to multiple the vertex label sizes by.}

\item{\ldots}{Other arguments passed to \code{\link[qdap]{Filter}}.}
}
\value{
Returns an igraph object.
}
\description{
Create \href{http://trinker.github.io/many-eye}{Many Eyes} 
style phrase nets.
}
\note{
While \href{http://trinker.github.io/many-eye}{Many Eyes} 
phrase nets inspired this function the two outputs are not identical.  The
\code{\link[qdap]{phrase_net}} function operates off of correlations between 
words in sentences.
}
\examples{
\dontrun{
x <- "Questions must be at least 2 days old to be eligible for a bounty.
    There can only be 1 active bounty per question at any given time.
    Users must have at least 75 reputation to offer a bounty, and may
    only have a maximum of 3 active bounties at any given time. The
    bounty period lasts 7 days. Bounties must have a minimum duration of
    at least 1 day. After the bounty ends, there is a grace period of 24
    hours to manually award the bounty. If you do not award your bounty
    within 7 days (plus the grace period), the highest voted answer
    created after the bounty started with at least 2 upvotes will be
    awarded half the bounty amount. If there's no answer meeting that
    criteria, the bounty is not awarded to anyone. If the bounty was
    started by the question owner, and the question owner accepts an
    answer during the bounty period, and the bounty expires without an
    explicit award - we assume the bounty owner liked the answer they
    accepted and award it the full bounty amount at the time of bounty
    expiration. In any case, you will always give up the amount of
    reputation specified in the bounty, so if you start a bounty, be sure
    to follow up and award your bounty to the best answer! As an
    additional bonus, bounty awards are immune to the daily reputation
    cap and community wiki mode."

phrase_net(sent_detect(x), r=.5)
library(igraph)
plot(phrase_net(sent_detect(x), r=.5), edge.curved = FALSE)

## Declaration of Independence Example
y <- readLines("http://www.constitution.org/usdeclar.txt")
y <- paste(y[grep("When, in the", y):length(y)], collapse=" ")
phrase_net(sent_detect(y), r=.7)


## Multiple grouping variables
z <- lapply(split(raj.act.1$dialogue, raj.act.1$person), paste, collapse = " ")
par(mfrow=c(2, 5), mai = c(.05, 0.15, 0.15, 0.15))
lapply(seq_along(z), function(i) {
    x <- try(phrase_net(sent_detect(z[i]), r=.6))
    if (!inherits(x, "try-error")) {
        print(x)
        box()
        mtext(names(z)[i])
    }
}) 


lapply(seq_along(z), function(i) {
    x <- try(phrase_net(sent_detect(z[i]), r=.6))
    if (!inherits(x, "try-error")) {
        dev.new()
        print(x)
        mtext(names(z)[i], padj=-1, cex=1.7, col="red")
    }
}) 
}
}
\references{
\url{http://trinker.github.io/many-eye}
}
\keyword{phrase_net}
