% Generated by roxygen2 (4.0.2): do not edit by hand
\name{rm_bracket}
\alias{rm_angle}
\alias{rm_bracket}
\alias{rm_bracket_multiple}
\alias{rm_curly}
\alias{rm_round}
\alias{rm_square}
\title{Remove/Replace/Extract Brackets}
\usage{
rm_bracket(text.var, pattern = "all", trim = TRUE, clean = TRUE,
  replacement = "", extract = FALSE, include.markers = ifelse(extract,
  FALSE, TRUE), dictionary = getOption("regex.library"), ...)

rm_round(text.var, pattern = "(", trim = TRUE, clean = TRUE,
  replacement = "", extract = FALSE, include.markers = ifelse(extract,
  FALSE, TRUE), dictionary = getOption("regex.library"), ...)

rm_square(text.var, pattern = "[", trim = TRUE, clean = TRUE,
  replacement = "", extract = FALSE, include.markers = ifelse(extract,
  FALSE, TRUE), dictionary = getOption("regex.library"), ...)

rm_curly(text.var, pattern = "{", trim = TRUE, clean = TRUE,
  replacement = "", extract = FALSE, include.markers = ifelse(extract,
  FALSE, TRUE), dictionary = getOption("regex.library"), ...)

rm_angle(text.var, pattern = "<", trim = TRUE, clean = TRUE,
  replacement = "", extract = FALSE, include.markers = ifelse(extract,
  FALSE, TRUE), dictionary = getOption("regex.library"), ...)

rm_bracket_multiple(text.var, trim = TRUE, clean = TRUE, pattern = "all",
  replacement = "", extract = FALSE, include.markers = FALSE,
  merge = TRUE)
}
\arguments{
\item{text.var}{The text variable.}

\item{pattern}{The type of bracket (and encased text) to remove.  This is one
or more of the strings \code{"curly"}/\code{"\{"}, \code{"square"}/\code{"["},
\code{"round"}/\code{"("}, \code{"angle"}/\code{"<"} and \code{"all"}.  These
strings correspond to: \{, [, (, < or all four types.}

\item{trim}{logical.  If \code{TRUE} removes leading and trailing white
spaces.}

\item{clean}{trim logical.  If \code{TRUE} extra white spaces and escaped
character will be removed.}

\item{replacement}{Replacement for matched \code{pattern}.}

\item{extract}{logical.  If \code{TRUE} the bracketed text is extracted into
a list of vectors.}

\item{include.markers}{logical.  If \code{TRUE} and \code{extract = TRUE} returns
the markers (left/right) and the text between.}

\item{dictionary}{A dictionary of canned regular expressions to search within
if \code{pattern} begins with \code{"@rm_"}.}

\item{merge}{logical.  If \code{TRUE} the results of each bracket type will
be merged by string.  \code{FALSE} returns a named list of lists of vectors
of bracketed text per bracket type.}

\item{\dots}{Other arguments passed to \code{\link[base]{gsub}}.}
}
\value{
\code{rm_bracket} - returns a character string with
multiple brackets removed.  If \code{extract = TRUE} the results are
optionally merged and named by bracket type.  This is more flexible than
\code{rm_bracket} but slower.

\code{rm_round} - returns a character string with round brackets removed.

\code{rm_square} - returns a character string with square brackets
removed.

\code{rm_curly} - returns a character string with curly brackets
removed.

\code{rm_angle} - returns a character string with angle brackets
removed.

\code{rm_bracket_multiple} - returns a character string with
multiple brackets removed.  If \code{extract = TRUE} the results are
optionally merged and named by bracket type.  This is more flexible than
\code{rm_bracket} but slower.
}
\description{
Remove/replace/extract bracketed strings.
}
\examples{
examp <- structure(list(person = structure(c(1L, 2L, 1L, 3L),
    .Label = c("bob", "greg", "sue"), class = "factor"), text =
    c("I love chicken [unintelligible]!",
    "Me too! (laughter) It's so good.[interrupting]",
    "Yep it's awesome {reading}.", "Agreed. {is so much fun}")), .Names =
    c("person", "text"), row.names = c(NA, -4L), class = "data.frame")

examp
rm_bracket(examp$text, pattern = "square")
rm_bracket(examp$text, pattern = "curly")
rm_bracket(examp$text, pattern = c("square", "round"))
rm_bracket(examp$text)

rm_bracket(examp$text, pattern = "square", extract=TRUE)
rm_bracket(examp$text, pattern = "curly", extract=TRUE)
rm_bracket(examp$text, pattern = c("square", "round"), extract=TRUE)
rm_bracket(examp$text, pattern = c("square", "round"), merge = FALSE, extract=TRUE)
rm_bracket(examp$text, extract=TRUE)
rm_bracket(examp$tex, include.markers=TRUE, extract=TRUE)

\dontrun{
library(qdap)
rm_bracket(examp$tex, pattern="curly", extract=TRUE) \%>\%
  unlist() \%>\%
  na.omit() \%>\%
  paste2()
}

x <- "I like [bots] (not). And <likely> many do not {he he}"

rm_round(x)
rm_round(x, extract = TRUE)

rm_round(x, include.marker = FALSE)
rm_round(x, extract = TRUE, include.marker = TRUE)

rm_square(x)
rm_square(x, extract = TRUE)

rm_curly(x)
rm_curly(x, extract = TRUE)

rm_angle(x)
rm_angle(x, extract = TRUE)

lapply(rm_between('She said, "I am!" and he responded..."Am what?".',
    left='"', right='"', extract = TRUE), "[", c(TRUE, FALSE))
}
\author{
Martin Morgan and Tyler Rinker <tyler.rinker@gmail.com>.
}
\references{
\url{http://stackoverflow.com/q/8621066/1000343}
}
\seealso{
\code{\link[base]{gsub}},
\code{\link[qdapRegex]{rm_between}},
\code{\link[stringi]{stri_extract_all_regex}}
}
\keyword{bracket}

