context("Checking as_time")

test_that("as_time converts extracted time stamp strings to time",{

    x <- list("3:04", c("10:47", "0:47"), NA_character_, "12:04", c("12:04", 
        "1:22"), c("08:15", "00:08:15.0"), c("3:15", "1:03:15.0"), c("01:22:30", 
        "01:22:30.0"), c("#00:09:33-5", "00:09:33.5"), c("00:09.33,75", 
        "00:09:33.75"))

    expect_equal(as_time(x), list("00:03:04.0", c("00:10:47.0", "00:00:47.0"), NA_character_, 
        "00:12:04.0", c("00:12:04.0", "00:01:22.0"), c("00:08:15.0", 
        "00:08:15.0"), c("00:03:15.0", "01:03:15.0"), c("01:22:30.0", 
        "01:22:30.0"), c("00:09:33.5", "00:09:33.5"), c("00:09:33.75", 
        "00:09:33.75"))
    )

    expect_equal(as_time(x, millisecond = FALSE), 
        list("00:03:4", c("00:10:47", "00:00:47"), NA_character_, "00:12:4", 
            c("00:12:4", "00:01:22"), c("00:08:15", "00:08:15"), c("00:03:15", 
            "01:03:15"), c("01:22:30", "01:22:30"), c("00:09:33", "00:09:33"),
            c("00:09:34", "00:09:34"))
    )
    
    expect_equal(as_time2(x), c("00:03:04.0", "00:10:47.0", "00:00:47.0", NA, "00:12:04.0", 
        "00:12:04.0", "00:01:22.0", "00:08:15.0", "00:08:15.0", "00:03:15.0", 
        "01:03:15.0", "01:22:30.0", "01:22:30.0", "00:09:33.5", "00:09:33.5", 
        "00:09:33.75", "00:09:33.75")
    )
    
})

