% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rm_bracket.R
\name{rm_bracket}
\alias{rm_bracket}
\alias{rm_round}
\alias{rm_square}
\alias{rm_curly}
\alias{rm_angle}
\alias{rm_bracket_multiple}
\alias{ex_bracket}
\alias{ex_bracket_multiple}
\alias{ex_angle}
\alias{ex_round}
\alias{ex_square}
\alias{ex_curly}
\title{Remove/Replace/Extract Brackets}
\usage{
rm_bracket(text.var, pattern = "all", trim = TRUE, clean = TRUE,
  replacement = "", extract = FALSE, include.markers = ifelse(extract,
  FALSE, TRUE), dictionary = getOption("regex.library"), ...)

rm_round(text.var, pattern = "(", trim = TRUE, clean = TRUE,
  replacement = "", extract = FALSE, include.markers = ifelse(extract,
  FALSE, TRUE), dictionary = getOption("regex.library"), ...)

rm_square(text.var, pattern = "[", trim = TRUE, clean = TRUE,
  replacement = "", extract = FALSE, include.markers = ifelse(extract,
  FALSE, TRUE), dictionary = getOption("regex.library"), ...)

rm_curly(text.var, pattern = "{", trim = TRUE, clean = TRUE,
  replacement = "", extract = FALSE, include.markers = ifelse(extract,
  FALSE, TRUE), dictionary = getOption("regex.library"), ...)

rm_angle(text.var, pattern = "<", trim = TRUE, clean = TRUE,
  replacement = "", extract = FALSE, include.markers = ifelse(extract,
  FALSE, TRUE), dictionary = getOption("regex.library"), ...)

rm_bracket_multiple(text.var, trim = TRUE, clean = TRUE, pattern = "all",
  replacement = "", extract = FALSE, include.markers = FALSE,
  merge = TRUE)

ex_bracket(text.var, pattern = "all", trim = TRUE, clean = TRUE,
  replacement = "", extract = TRUE, include.markers = ifelse(extract,
  FALSE, TRUE), dictionary = getOption("regex.library"), ...)

ex_bracket_multiple(text.var, trim = TRUE, clean = TRUE, pattern = "all",
  replacement = "", extract = TRUE, include.markers = FALSE,
  merge = TRUE)

ex_angle(text.var, pattern = "<", trim = TRUE, clean = TRUE,
  replacement = "", extract = TRUE, include.markers = ifelse(extract,
  FALSE, TRUE), dictionary = getOption("regex.library"), ...)

ex_round(text.var, pattern = "(", trim = TRUE, clean = TRUE,
  replacement = "", extract = TRUE, include.markers = ifelse(extract,
  FALSE, TRUE), dictionary = getOption("regex.library"), ...)

ex_square(text.var, pattern = "[", trim = TRUE, clean = TRUE,
  replacement = "", extract = TRUE, include.markers = ifelse(extract,
  FALSE, TRUE), dictionary = getOption("regex.library"), ...)

ex_curly(text.var, pattern = "{", trim = TRUE, clean = TRUE,
  replacement = "", extract = TRUE, include.markers = ifelse(extract,
  FALSE, TRUE), dictionary = getOption("regex.library"), ...)
}
\arguments{
\item{text.var}{The text variable.}

\item{pattern}{The type of bracket (and encased text) to remove.  This is one 
or more of the strings \code{"curly"}/\code{"\{"}, \code{"square"}/\code{"["}, 
\code{"round"}/\code{"("}, \code{"angle"}/\code{"<"} and \code{"all"}.  These 
strings correspond to: \{, [, (, < or all four types.}

\item{trim}{logical.  If \code{TRUE} removes leading and trailing white 
spaces.}

\item{clean}{trim logical.  If \code{TRUE} extra white spaces and escaped 
character will be removed.}

\item{replacement}{Replacement for matched \code{pattern}.}

\item{extract}{logical.  If \code{TRUE} the bracketed text is extracted into 
a list of vectors.}

\item{include.markers}{logical.  If \code{TRUE} and \code{extract = TRUE} returns 
the markers (left/right) and the text between.}

\item{dictionary}{A dictionary of canned regular expressions to search within 
if \code{pattern} begins with \code{"@rm_"}.}

\item{\dots}{Other arguments passed to \code{\link[base]{gsub}}.}

\item{merge}{logical.  If \code{TRUE} the results of each bracket type will 
be merged by string.  \code{FALSE} returns a named list of lists of vectors 
of bracketed text per bracket type.}
}
\value{
\code{rm_bracket} - returns a character string with 
multiple brackets removed.  If \code{extract = TRUE} the results are 
optionally merged and named by bracket type.  This is more flexible than 
\code{rm_bracket} but slower.

\code{rm_round} - returns a character string with round brackets removed.

\code{rm_square} - returns a character string with square brackets 
removed.

\code{rm_curly} - returns a character string with curly brackets 
removed.

\code{rm_angle} - returns a character string with angle brackets 
removed.

\code{rm_bracket_multiple} - returns a character string with 
multiple brackets removed.  If \code{extract = TRUE} the results are 
optionally merged and named by bracket type.  This is more flexible than 
\code{rm_bracket} but slower.
}
\description{
Remove/replace/extract bracketed strings.
}
\examples{
examp <- structure(list(person = structure(c(1L, 2L, 1L, 3L),
    .Label = c("bob", "greg", "sue"), class = "factor"), text =
    c("I love chicken [unintelligible]!",
    "Me too! (laughter) It's so good.[interrupting]",
    "Yep it's awesome {reading}.", "Agreed. {is so much fun}")), .Names =
    c("person", "text"), row.names = c(NA, -4L), class = "data.frame")

examp
rm_bracket(examp$text, pattern = "square")
rm_bracket(examp$text, pattern = "curly")
rm_bracket(examp$text, pattern = c("square", "round"))
rm_bracket(examp$text)

ex_bracket(examp$text, pattern = "square")
ex_bracket(examp$text, pattern = "curly")
ex_bracket(examp$text, pattern = c("square", "round"))
ex_bracket(examp$text, pattern = c("square", "round"), merge = FALSE)
ex_bracket(examp$text)
ex_bracket(examp$tex, include.markers=TRUE)

\dontrun{
library(qdap)
ex_bracket(examp$tex, pattern="curly") \%>\% 
  unlist() \%>\% 
  na.omit() \%>\% 
  paste2()
}

x <- "I like [bots] (not). And <likely> many do not {he he}"

rm_round(x)
ex_round(x)
ex_round(x, include.marker = TRUE)

rm_square(x)
ex_square(x)

rm_curly(x)
ex_curly(x)

rm_angle(x)
ex_angle(x)

lapply(ex_between('She said, "I am!" and he responded..."Am what?".', 
    left='"', right='"'), "[", c(TRUE, FALSE))
}
\references{
\url{http://stackoverflow.com/q/8621066/1000343}
}
\seealso{
\code{\link[base]{gsub}},
\code{\link[qdapRegex]{rm_between}},
\code{\link[stringi]{stri_extract_all_regex}}

Other rm_ functions: \code{\link{rm_abbreviation}},
  \code{\link{rm_between}}, \code{\link{rm_caps_phrase}},
  \code{\link{rm_caps}}, \code{\link{rm_citation_tex}},
  \code{\link{rm_citation}},
  \code{\link{rm_city_state_zip}},
  \code{\link{rm_city_state}}, \code{\link{rm_date}},
  \code{\link{rm_default}}, \code{\link{rm_dollar}},
  \code{\link{rm_email}}, \code{\link{rm_emoticon}},
  \code{\link{rm_endmark}}, \code{\link{rm_hash}},
  \code{\link{rm_nchar_words}}, \code{\link{rm_non_ascii}},
  \code{\link{rm_non_words}}, \code{\link{rm_number}},
  \code{\link{rm_percent}}, \code{\link{rm_phone}},
  \code{\link{rm_postal_code}},
  \code{\link{rm_repeated_characters}},
  \code{\link{rm_repeated_phrases}},
  \code{\link{rm_repeated_words}}, \code{\link{rm_tag}},
  \code{\link{rm_time}}, \code{\link{rm_title_name}},
  \code{\link{rm_url}}, \code{\link{rm_white}},
  \code{\link{rm_zip}}
}
\author{
Martin Morgan and Tyler Rinker <tyler.rinker@gmail.com>.
}
\keyword{bracket}
