% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/base.R
\name{pointwisebound.noboot}
\alias{pointwisebound.noboot}
\title{estimating pointwise comparisons for qgcomp.noboot objects}
\usage{
pointwisebound.noboot(x, alpha = 0.05, pointwiseref = 1)
}
\arguments{
\item{x}{"qgcompfit" object from `qgcomp.boot`,}

\item{alpha}{alpha level for confidence intervals}

\item{pointwiseref}{referent quantile (e.g. 1 uses the lowest joint-exposure category as 
the referent category for calculating all mean differences/standard deviations)}
}
\value{
A data frame containing expected values of the outcome at each quantized value
of all exposures as well as a mean difference contrasting the expected outcome at each
quantized value of all exposures, and associated standard error and confidence intervals.
}
\description{
Calculates: expected outcome (on the link scale), mean difference (link scale)
and the standard error of the mean difference (link scale) for pointwise comparisons
}
\details{
The comparison of interest following a qgcomp fit is often comparisons of model
predictions at various values of the joint-exposures (e.g. expected outcome at all exposures
at the 1st quartile vs. the 3rd quartile). The expected outcome at a given joint exposure 
and at a given level of non-exposure covariates (W) is 
given as E(Y|S,W=w), where S takes on integer values 0 to q-1. Thus, comparisons are of the type
E(Y|S=s,W=w) - E(Y|S=s2,W=w) where s and s2 are two different values of the joint exposures (e.g. 0 and 2).
This function yields E(Y|S,W=w) as well as E(Y|S=s,W=w) - E(Y|S=p,W=w) where s is any value of S and p is
the value chosen via "pointwise ref" - e.g. for binomial variables this will equal the risk/
prevalence difference at all values of S, with the referent category S=p-1. For the non-boostrapped
version of quantile g-computation (under a linear model)

 \eqn{f(\beta) = \sum_i^p \beta_i}
given gradient vector 
\deqn{G = [\partial(f(\beta))/\partial\beta_1 = 1,
  ...,
  \partial(f(\beta))/\partial\beta_3k= 1]
  }
\eqn{t(G) Cov(\beta)  G} = delta method variance, where t() is the transpose operator
and \eqn{\partial y/ \partial x} denotes the partial derivative/gradient and G is the 
"gradient vector". The vector G takes on values that equal the difference in quantiles of 
S for each pointwise comparison (e.g. for a comparison of the 3rd vs the 5th category,
G is a vector of 2s)

This is used to create pointwise confidence intervals
}
\examples{
set.seed(12)
\donttest{
n = 100
dat <- data.frame(x1=(x1 <- runif(n)), x2=(x2 <- runif(n)), x3=(x3 <- runif(n)), z=(z <- runif(n)),
                  y=rnorm(n)+x1 + x2 - x3 +z)
ft <- qgcomp.noboot(y ~ z + x1 + x2 + x3, expnms=c('x1','x2','x3'), data=dat, q=10)
ft2 <- qgcomp.boot(y ~ z + x1 + x2 + x3, expnms=c('x1','x2','x3'), data=dat, q=10)
pointwisebound.noboot(ft, alpha=0.05, pointwiseref=3)
pointwisebound.boot(ft2, alpha=0.05, pointwiseref=3)
dat <- data.frame(x1=(x1 <- runif(n)), x2=(x2 <- runif(n)), x3=(x3 <- runif(n)), z=(z <- runif(n)),
                  y=rbinom(n, 1, 1/(1+exp(-(x1 + x2 - x3 +z)))))
ft <- qgcomp.noboot(y ~ z + x1 + x2 + x3, expnms=c('x1','x2','x3'), data=dat, q=10)
ft2 <- qgcomp.boot(y ~ z + x1 + x2 + x3, expnms=c('x1','x2','x3'), data=dat, q=10)
pointwisebound.noboot(ft, alpha=0.05, pointwiseref=3)
pointwisebound.boot(ft2, alpha=0.05, pointwiseref=3)
}  
}
\seealso{
\code{\link[qgcomp]{qgcomp.noboot}}, \code{\link[qgcomp]{pointwisebound.boot}}
}
