% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multiple_marker_test.R
\name{vegas}
\alias{vegas}
\title{Perform VEGAS Gene-Based Association Analysis}
\usage{
vegas(
  Glist = NULL,
  sets = NULL,
  stat = NULL,
  p = NULL,
  threshold = 1e-10,
  tol = 1e-07,
  minsize = 2,
  verbose = FALSE
)
}
\arguments{
\item{Glist}{A list containing genomic information, such as LD matrices or genotype data. Required.}

\item{sets}{A list of sets (e.g., genes with their associated markers) to analyze. Required.}

\item{stat}{A data frame containing marker-level statistics. Must include `rsids` (marker IDs) and `p` (p-values).}

\item{p}{A numeric matrix of p-values for markers across multiple studies. If provided, `stat` should be NULL.}

\item{threshold}{A numeric value specifying the lower bound for p-values to avoid numerical issues. Default is `1e-10`.}

\item{tol}{A numeric value specifying the tolerance for eigenvalues in LD matrices. Default is `1e-7`.}

\item{minsize}{An integer specifying the minimum number of markers required for a set to be analyzed. Default is `2`.}

\item{verbose}{A logical value indicating whether to print progress messages. Default is `FALSE`.}
}
\value{
A data frame with the results
}
\description{
This function performs VEGAS (Versatile Gene-based Association Study) to analyze gene-level associations
using marker statistics and linkage disequilibrium (LD) structure from a reference panel.
}
\details{
The function uses marker-level statistics to compute gene-level association statistics,
accounting for LD structure among markers. The LD structure is retrieved from `Glist`, which
should include precomputed LD matrices or genotype data for the markers.

Two modes are supported:
- **`stat` Mode**: Uses marker statistics (e.g., p-values) from a single study to compute gene-level statistics.
- **`p` Mode**: Uses marker p-values across multiple studies for meta-analysis of gene-level statistics.
}
