% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qgis-tmp.R
\name{qgis_tmp_file}
\alias{qgis_tmp_file}
\alias{qgis_tmp_folder}
\alias{qgis_tmp_vector}
\alias{qgis_tmp_raster}
\alias{qgis_tmp_base}
\alias{qgis_clean_tmp}
\title{Manage temporary files}
\usage{
qgis_tmp_file(ext)

qgis_tmp_folder()

qgis_tmp_vector(ext = getOption("qgisprocess.tmp_vector_ext", ".gpkg"))

qgis_tmp_raster(ext = getOption("qgisprocess.tmp_raster_ext", ".tif"))

qgis_tmp_base()

qgis_clean_tmp()
}
\arguments{
\item{ext}{The file extension to be used.}
}
\value{
A character vector indicating the location of a
(not yet created) temporary file.
}
\description{
These functions create temporary files that can be used
in calls to \code{\link[=qgis_run_algorithm]{qgis_run_algorithm()}} or elsewhere. These
files are created in a special temporary directory
(\code{\link[=qgis_tmp_base]{qgis_tmp_base()}}) that should be periodically cleaned up
using \code{\link[=qgis_clean_tmp]{qgis_clean_tmp()}}. You can set your preferred
vector and/or raster file extension using
\code{options(qgisprocess.tmp_vector_ext = "...")} and/or
\code{options(qgisprocess.tmp_raster_ext = "...")}, respectively.
}
\examples{
qgis_tmp_base()
qgis_tmp_file(".csv")
qgis_tmp_vector()
qgis_tmp_raster()

}
\seealso{
Other topics about programming or debugging utilities: 
\code{\link{qgis_result_status}()},
\code{\link{qgis_run}()},
\code{\link{qgis_unconfigure}()},
\code{\link{qgis_using_json_input}()}
}
\concept{topics about programming or debugging utilities}
