% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/feature_selection.R
\name{feature_selection}
\alias{feature_selection}
\title{Variable selection using the qmd-dependence values}
\usage{
feature_selection(
  X,
  y,
  method = "combVar",
  bin.size = "fixed",
  plot = TRUE,
  na.exclude = FALSE,
  max_num_features = NULL,
  plot.title = NULL,
  plot.color = "hotpink"
)
}
\arguments{
\item{X}{a numeric matrix or data.frame of dimension d containing the explanatory variables}

\item{y}{a numeric vector containing the uni-variate response variable}

\item{method}{possible options are c("combVar", "addVar"), see Details.}

\item{bin.size}{either "fixed", "adaptive" or "sparse.adaptive", indicating whether the checkerboard copula may vary its bin sizes (defaults to "fixed"). Setting this to "adaptive" might affect the results but will be faster if the sample has many ties.}

\item{plot}{logical indicating whether the feature selection plot is printed}

\item{na.exclude}{logical if all rows containing NAs should be removed.}

\item{max_num_features}{maximal number of explanatory variables to be selected}

\item{plot.title}{a label for the title}

\item{plot.color}{a colour for the selected variables}
}
\value{
a list containing a data.frame (result) and the corresponding plots.
The data.frame result contains the number of explanatory variables (nVars),
the combination of selected variables (selVars),
the dependence measure zeta1 (qmd) of the selected variables to the response y
and the resolution of the empirical checkerboard copula (ECBC_resolution).
For the method "combVar" the dependence value zeta1 (qmd) is returned for all combinations of explanatory variables and is sorted in decreasing order according to zeta1.
}
\description{
Given a d-dimensional random vector X containing the explanatory variables and a uni-variate response variable y,
this function uses the qmd-dependence values to select the most relevant (influential) explanatory variables.
Two different methods are available and are explained in the section Details.
}
\details{
method 1 (default) - "combVar": computes all qmd-dependence scores, i.e., calculates the dependence of every combination of explanatory variables to the response variable y and selects for each number of explanatory variables the combination with the greatest dependence score. This procedure is computational expensive and is only available up to 15 explanatory variables.

method 2 - "addVar": stepwise procedure which calculates all bi-variate dependence values q(X_i,Y) and selects the variable X_j exhibiting the greatest dependence value. In the next step all three-dimensional combinations q((X_j, X_i), Y) (for every i =1,..., d and i not j) are computed and the variable exhibiting again the greatest dependence score is added. In this manner the procedure works up to dimension d.
}
\examples{
n <- 1000
x1 <- runif(n)
x2 <- rexp(n)
x3 <- x1 + log(x2) + rnorm(n)
x4 <- rnorm(n)
x5 <- x4^2
x6 <- x1 + x5 + rnorm(n)
x7 <- 1:n
y <- x2 + x4*x7 + runif(n)
X <- data.frame(x1,x2,x3,x4,x5,x6,x7)
fit <- feature_selection(X, y, method = "combVar", plot = TRUE)
fit <- feature_selection(X, y, method = "addVar", plot = TRUE)
}
